<?php
/**
 * Script para eliminar TODAS las asignaciones de Lizet Martija del proyecto 376
 * Usuario: Lizet Martija (lizetm, auxiliar.rh@rinorisk.com)
 * Proyecto: 376
 */

require_once __DIR__ . '/config/database.php';

try {
    $db = Database::getConnection();
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== ELIMINACIÓN DE ASIGNACIONES DE LIZET MARTIJA DEL PROYECTO 376 ===\n\n";
    
    // Encontrar el usuario
    $stmt = $db->prepare("
        SELECT user_id, username, email, full_name 
        FROM Users 
        WHERE email = 'auxiliar.rh@rinorisk.com' 
           OR username = 'lizetm' 
           OR full_name LIKE '%Lizet%Martija%'
    ");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "❌ ERROR: No se encontró el usuario Lizet Martija\n";
        exit(1);
    }
    
    $userId = $user['user_id'];
    echo "✅ Usuario encontrado:\n";
    echo "   - ID: {$userId}\n";
    echo "   - Nombre: {$user['full_name']}\n";
    echo "   - Email: {$user['email']}\n";
    echo "   - Username: {$user['username']}\n\n";
    
    // Verificar asignaciones en Task_Assignments
    echo "1. VERIFICANDO ASIGNACIONES EN Task_Assignments:\n";
    $stmt = $db->prepare("
        SELECT 
            t.task_id,
            t.task_name,
            ta.assigned_percentage
        FROM Task_Assignments ta
        INNER JOIN Tasks t ON ta.task_id = t.task_id
        WHERE t.project_id = 376 AND ta.user_id = ?
    ");
    $stmt->execute([$userId]);
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($assignments) > 0) {
        echo "   📋 Encontradas " . count($assignments) . " asignación(es):\n";
        foreach ($assignments as $a) {
            echo "      - Tarea #{$a['task_id']}: {$a['task_name']} ({$a['assigned_percentage']}%)\n";
        }
    } else {
        echo "   ✅ No hay asignaciones en Task_Assignments\n";
    }
    
    // Verificar asignaciones directas en Tasks
    echo "\n2. VERIFICANDO ASIGNACIONES DIRECTAS EN Tasks:\n";
    $stmt = $db->prepare("
        SELECT 
            task_id,
            task_name,
            assigned_to_user_id
        FROM Tasks
        WHERE project_id = 376 AND assigned_to_user_id = ?
    ");
    $stmt->execute([$userId]);
    $directAssignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($directAssignments) > 0) {
        echo "   📋 Encontradas " . count($directAssignments) . " asignación(es) directa(s):\n";
        foreach ($directAssignments as $a) {
            echo "      - Tarea #{$a['task_id']}: {$a['task_name']} (Asignación directa)\n";
        }
    } else {
        echo "   ✅ No hay asignaciones directas\n";
    }
    
    $total = count($assignments) + count($directAssignments);
    echo "\n📊 RESUMEN TOTAL: {$total} asignación(es) encontrada(s)\n\n";
    
    if ($total == 0) {
        echo "✅ El usuario no tiene asignaciones en el proyecto 376\n";
        exit(0);
    }
    
    // Proceder con la eliminación
    echo "🗑️  ELIMINANDO ASIGNACIONES...\n\n";
    
    $db->beginTransaction();
    
    try {
        $deletedCount = 0;
        
        // Eliminar de Task_Assignments
        if (count($assignments) > 0) {
            $stmt = $db->prepare("
                DELETE ta FROM Task_Assignments ta
                INNER JOIN Tasks t ON ta.task_id = t.task_id
                WHERE t.project_id = 376 AND ta.user_id = ?
            ");
            $stmt->execute([$userId]);
            $deletedCount = $stmt->rowCount();
            echo "✅ Eliminadas {$deletedCount} asignación(es) de Task_Assignments\n";
        }
        
        // Eliminar asignaciones directas (poner NULL)
        if (count($directAssignments) > 0) {
            $stmt = $db->prepare("
                UPDATE Tasks 
                SET assigned_to_user_id = NULL 
                WHERE project_id = 376 AND assigned_to_user_id = ?
            ");
            $stmt->execute([$userId]);
            $directDeleted = $stmt->rowCount();
            echo "✅ Eliminadas {$directDeleted} asignación(es) directa(s)\n";
            $deletedCount += $directDeleted;
        }
        
        $db->commit();
        
        echo "\n✅ ÉXITO: Se eliminaron {$deletedCount} asignación(es) en total\n";
        echo "✅ Usuario {$user['full_name']} ({$user['email']}) ya no está asignado a tareas del proyecto 376\n";
        
        // Verificación final
        echo "\n🔍 VERIFICACIÓN FINAL:\n";
        $stmt = $db->prepare("
            SELECT COUNT(*) as remaining
            FROM Task_Assignments ta
            INNER JOIN Tasks t ON ta.task_id = t.task_id
            WHERE t.project_id = 376 AND ta.user_id = ?
        ");
        $stmt->execute([$userId]);
        $remaining = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $stmt2 = $db->prepare("
            SELECT COUNT(*) as remaining_direct
            FROM Tasks
            WHERE project_id = 376 AND assigned_to_user_id = ?
        ");
        $stmt2->execute([$userId]);
        $remainingDirect = $stmt2->fetch(PDO::FETCH_ASSOC);
        
        $totalRemaining = $remaining['remaining'] + $remainingDirect['remaining_direct'];
        
        if ($totalRemaining == 0) {
            echo "✅ Verificación: No quedan asignaciones (eliminación completa)\n";
        } else {
            echo "⚠️  ADVERTENCIA: Aún quedan {$totalRemaining} asignación(es)\n";
        }
        
    } catch (Exception $e) {
        $db->rollBack();
        throw $e;
    }
    
} catch (Exception $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
    exit(1);
}

