<?php
/**
 * Script para eliminar asignaciones de Lizet Martija del proyecto 482
 * Usuario: Lizet Martija (lizetm, auxiliar.rh@rinorisk.com)
 */

require_once __DIR__ . '/config/database.php';

try {
    $db = Database::getConnection();
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== ELIMINACIÓN DE ASIGNACIONES DE LIZET MARTIJA DEL PROYECTO 482 ===\n\n";
    
    // Paso 1: Encontrar el usuario
    $stmt = $db->prepare("
        SELECT user_id, username, email, full_name 
        FROM Users 
        WHERE email = 'auxiliar.rh@rinorisk.com' 
           OR username = 'lizetm' 
           OR full_name LIKE '%Lizet%Martija%'
    ");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "❌ ERROR: No se encontró el usuario Lizet Martija\n";
        exit(1);
    }
    
    echo "✅ Usuario encontrado:\n";
    echo "   - ID: {$user['user_id']}\n";
    echo "   - Nombre: {$user['full_name']}\n";
    echo "   - Email: {$user['email']}\n";
    echo "   - Username: {$user['username']}\n\n";
    
    $userId = $user['user_id'];
    
    // Paso 2: Contar asignaciones antes de eliminar
    $stmt = $db->prepare("
        SELECT COUNT(*) as total
        FROM Task_Assignments ta
        INNER JOIN Tasks t ON ta.task_id = t.task_id
        WHERE t.project_id = 482 AND ta.user_id = ?
    ");
    $stmt->execute([$userId]);
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalAssignments = $count['total'];
    
    echo "📊 Asignaciones encontradas: {$totalAssignments}\n\n";
    
    if ($totalAssignments == 0) {
        echo "✅ No hay asignaciones para eliminar.\n";
        exit(0);
    }
    
    // Paso 3: Mostrar las tareas afectadas
    $stmt = $db->prepare("
        SELECT 
            t.task_id,
            t.task_name,
            ta.assigned_percentage
        FROM Task_Assignments ta
        INNER JOIN Tasks t ON ta.task_id = t.task_id
        WHERE t.project_id = 482 AND ta.user_id = ?
        ORDER BY t.task_id
    ");
    $stmt->execute([$userId]);
    $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "📋 Tareas afectadas:\n";
    foreach ($tasks as $task) {
        echo "   - Tarea #{$task['task_id']}: {$task['task_name']} ({$task['assigned_percentage']}%)\n";
    }
    echo "\n";
    
    // Paso 4: Confirmar eliminación
    echo "⚠️  ¿Deseas continuar con la eliminación? (s/n): ";
    $handle = fopen("php://stdin", "r");
    $line = trim(fgets($handle));
    fclose($handle);
    
    if (strtolower($line) !== 's' && strtolower($line) !== 'y' && strtolower($line) !== 'si') {
        echo "❌ Operación cancelada.\n";
        exit(0);
    }
    
    // Paso 5: Eliminar asignaciones
    $db->beginTransaction();
    
    try {
        $stmt = $db->prepare("
            DELETE ta FROM Task_Assignments ta
            INNER JOIN Tasks t ON ta.task_id = t.task_id
            WHERE t.project_id = 482 AND ta.user_id = ?
        ");
        $stmt->execute([$userId]);
        $deletedCount = $stmt->rowCount();
        
        $db->commit();
        
        echo "\n✅ ÉXITO: Se eliminaron {$deletedCount} asignación(es)\n";
        echo "✅ Usuario {$user['full_name']} ({$user['email']}) ya no está asignado a tareas del proyecto 482\n";
        
    } catch (Exception $e) {
        $db->rollBack();
        throw $e;
    }
    
    // Paso 6: Verificar que se eliminaron
    $stmt = $db->prepare("
        SELECT COUNT(*) as remaining
        FROM Task_Assignments ta
        INNER JOIN Tasks t ON ta.task_id = t.task_id
        WHERE t.project_id = 482 AND ta.user_id = ?
    ");
    $stmt->execute([$userId]);
    $remaining = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($remaining['remaining'] == 0) {
        echo "✅ Verificación: No quedan asignaciones (eliminación completa)\n";
    } else {
        echo "⚠️  ADVERTENCIA: Aún quedan {$remaining['remaining']} asignación(es)\n";
    }
    
} catch (Exception $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    exit(1);
}

