#!/bin/bash

# Script para monitorear cambios y desplegar automáticamente
# Requiere fswatch: brew install fswatch (en macOS)

set -e

# Configuración
LOCAL_PATH="/Users/abdiel/Documents/Proyectos/htdocs/rinotrackalfa"
DEPLOY_SCRIPT="$LOCAL_PATH/auto-deploy.sh"

# Colores
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m'

echo -e "${BLUE}🔍 Iniciando monitoreo automático de cambios...${NC}"
echo -e "${YELLOW}📁 Monitoreando: $LOCAL_PATH${NC}"
echo -e "${YELLOW}🚀 Script de despliegue: $DEPLOY_SCRIPT${NC}"
echo -e "${GREEN}✅ Presiona Ctrl+C para detener${NC}"
echo ""

# Verificar que fswatch esté instalado
if ! command -v fswatch &> /dev/null; then
    echo -e "${RED}❌ Error: fswatch no está instalado${NC}"
    echo -e "${YELLOW}💡 Instalar con: brew install fswatch${NC}"
    exit 1
fi

# Función para manejar el despliegue
deploy_changes() {
    echo -e "${YELLOW}📝 Cambios detectados en: $1${NC}"
    echo -e "${BLUE}🚀 Ejecutando auto-despliegue...${NC}"
    
    if "$DEPLOY_SCRIPT"; then
        echo -e "${GREEN}✅ Despliegue completado exitosamente${NC}"
        echo -e "${BLUE}🌐 Aplicación actualizada en: http://52.3.160.124/rinotrackalfa/public/${NC}"
    else
        echo -e "${RED}❌ Error en el despliegue${NC}"
    fi
    
    echo -e "${YELLOW}⏳ Esperando más cambios...${NC}"
    echo ""
}

# Exportar la función para que esté disponible en el subshell
export -f deploy_changes
export DEPLOY_SCRIPT
export GREEN YELLOW BLUE RED NC

# Monitorear cambios excluyendo ciertos directorios y archivos
fswatch -o \
    --exclude='.git' \
    --exclude='node_modules' \
    --exclude='.DS_Store' \
    --exclude='*.log' \
    --exclude='rinotrack.pem' \
    --exclude='watch-and-deploy.sh' \
    --exclude='.env' \
    "$LOCAL_PATH" | while read num; do
        deploy_changes "archivos del proyecto"
    done
