<?php
// Obtener el archivo de la base de datos
require_once __DIR__ . '/../config/database.php';

$id = $_GET['id'] ?? 0;
$type = $_GET['type'] ?? 'auto'; // 'task', 'subtask', o 'auto'

if (!$id) die('No ID');

$db = Database::getConnection();
$file = null;

// Si se especifica el tipo, buscar solo en esa tabla
if ($type === 'subtask') {
    $stmt = $db->prepare("SELECT *, 'subtask' as source_table FROM Subtask_Attachments WHERE attachment_id = ?");
    $stmt->execute([$id]);
    $file = $stmt->fetch();
} elseif ($type === 'task') {
    $stmt = $db->prepare("SELECT *, 'task' as source_table FROM Task_Attachments WHERE attachment_id = ?");
    $stmt->execute([$id]);
    $file = $stmt->fetch();
} else {
    // Modo auto: buscar en ambas tablas
    // Primero en Subtask_Attachments (prioridad para subtareas)
    $stmt = $db->prepare("SELECT *, 'subtask' as source_table FROM Subtask_Attachments WHERE attachment_id = ?");
    $stmt->execute([$id]);
    $subtaskFile = $stmt->fetch();
    
    // Luego en Task_Attachments
    $stmt = $db->prepare("SELECT *, 'task' as source_table FROM Task_Attachments WHERE attachment_id = ?");
    $stmt->execute([$id]);
    $taskFile = $stmt->fetch();
    
    // Prioridad: primero verificar si existe físicamente
    if ($subtaskFile && $taskFile) {
        error_log("file-viewer.php: ADVERTENCIA - ID duplicado $id encontrado en ambas tablas");
        
        // Verificar cuál existe físicamente
        $subtaskPath = __DIR__ . '/' . ($subtaskFile['file_path'] ?? '');
        $taskPath = __DIR__ . '/' . ($taskFile['file_path'] ?? '');
        
        $subtaskExists = file_exists($subtaskPath) && is_file($subtaskPath);
        $taskExists = file_exists($taskPath) && is_file($taskPath);
        
        if ($subtaskExists && !$taskExists) {
            $file = $subtaskFile;
            error_log("file-viewer.php: Usando subtask file (existe físicamente)");
        } elseif ($taskExists && !$subtaskExists) {
            $file = $taskFile;
            error_log("file-viewer.php: Usando task file (existe físicamente)");
        } else {
            // Si ambos existen o ninguno existe, usar el más reciente
            $file = ($subtaskFile['uploaded_at'] ?? '') > ($taskFile['uploaded_at'] ?? '') ? $subtaskFile : $taskFile;
            error_log("file-viewer.php: Usando el más reciente: " . $file['source_table']);
        }
    } elseif ($subtaskFile) {
        $file = $subtaskFile;
    } elseif ($taskFile) {
        $file = $taskFile;
    }
}

if (!$file) {
    error_log("file-viewer.php: Archivo no encontrado en BD con ID: $id");
    http_response_code(404);
    die('Not found in database');
}

// Buscar el archivo en el servidor
$filePath = $file['file_path'];
$fileName = basename($filePath);
$filePathWithoutUploads = str_replace(['uploads/', 'task_attachments/'], '', $filePath);

// Construir TODAS las posibles rutas donde podría estar el archivo
$paths = [];

// 1. Ruta exacta como está en la BD
$paths[] = __DIR__ . '/' . $filePath;

// 2. Si tiene uploads/ pero no task_attachments/, buscar en ambas ubicaciones
if (strpos($filePath, 'uploads/') === 0 && strpos($filePath, 'task_attachments/') === false) {
    $paths[] = __DIR__ . '/uploads/task_attachments/' . $fileName;
    $paths[] = __DIR__ . '/uploads/' . $fileName;
    $paths[] = __DIR__ . '/uploads/' . str_replace('uploads/', '', $filePath);
}

// 3. Si tiene task_attachments/, buscar ahí y también en uploads/ (por si acaso)
if (strpos($filePath, 'task_attachments/') !== false) {
    $paths[] = __DIR__ . '/uploads/task_attachments/' . $fileName;
    $paths[] = __DIR__ . '/uploads/' . $fileName;
}

// 4. Buscar solo por nombre de archivo en ambas ubicaciones
$paths[] = __DIR__ . '/uploads/task_attachments/' . $fileName;
$paths[] = __DIR__ . '/uploads/' . $fileName;

// 5. Si el file_path no tiene uploads/, agregarlo
if (strpos($filePath, 'uploads/') === false) {
    $paths[] = __DIR__ . '/uploads/task_attachments/' . $filePath;
    $paths[] = __DIR__ . '/uploads/task_attachments/' . $fileName;
    $paths[] = __DIR__ . '/uploads/' . $filePath;
    $paths[] = __DIR__ . '/uploads/' . $fileName;
}

// 6. Buscar sin prefijos
$paths[] = __DIR__ . '/' . $filePath;
$paths[] = __DIR__ . '/' . $fileName;

// Eliminar duplicados
$paths = array_unique($paths);

$found = null;
foreach ($paths as $path) {
    if (file_exists($path) && is_file($path)) {
        $found = $path;
        error_log("file-viewer.php: Archivo encontrado en: $path");
        break;
    }
}

// Si aún no se encuentra, buscar con glob pattern
if (!$found) {
    // Buscar por nombre exacto
    $pattern = $fileName;
    $searchDirs = [
        __DIR__ . '/uploads/task_attachments/',
        __DIR__ . '/uploads/'
    ];
    
    foreach ($searchDirs as $dir) {
        if (is_dir($dir)) {
            // Buscar exacto
            $exactPath = $dir . $pattern;
            if (file_exists($exactPath)) {
                $found = $exactPath;
                error_log("file-viewer.php: Archivo encontrado (exacto) en: $found");
                break;
            }
            
            // Buscar con wildcard
            $files = glob($dir . '*' . $pattern . '*');
            if (!empty($files)) {
                $found = $files[0];
                error_log("file-viewer.php: Archivo encontrado (wildcard) en: $found");
                break;
            }
        }
    }
}

if (!$found) {
    error_log("file-viewer.php: Archivo NO encontrado. file_path en BD: $filePath, fileName: $fileName");
    error_log("file-viewer.php: Rutas buscadas: " . implode(', ', $paths));
    http_response_code(404);
    die('File not found: ' . htmlspecialchars($fileName));
}


// Servir el archivo
$mime = mime_content_type($found);

header('Content-Type: ' . $mime);
header('Content-Length: ' . filesize($found));
readfile($found);
?>