// Variables globales para búsqueda
let searchTimeout;

// ============================================
// FUNCIONES GLOBALES (disponibles inmediatamente)
// ============================================

// Función para navegación de páginas
function goToPage(page) {
    const url = new URL(window.location);
    url.searchParams.set('page', page);

    // Mantener el término de búsqueda si existe
    const searchInput = document.getElementById('searchInput');
    if (searchInput && searchInput.value) {
        url.searchParams.set('search', searchInput.value);
    }

    window.location.href = url.toString();
}

// Función para toggle del dropdown de acciones
function toggleListMenu(memberId) {
    const dropdown = document.getElementById('listMenu' + memberId);
    if (!dropdown) {
        console.error('Dropdown no encontrado para memberId:', memberId);
        return;
    }

    const isOpen = dropdown.style.display === 'block';

    // Cerrar todos los dropdowns
    document.querySelectorAll('.dropdown-menu-list').forEach(menu => {
        menu.style.display = 'none';
    });

    // Abrir el dropdown actual si estaba cerrado
    if (!isOpen) {
        // Posicionar el dropdown
        const button = dropdown.previousElementSibling;
        const rect = button.getBoundingClientRect();

        dropdown.style.position = 'fixed';
        dropdown.style.top = (rect.bottom + 5) + 'px';
        dropdown.style.left = (rect.left - 120) + 'px'; // Ajustar para que no se salga
        dropdown.style.display = 'block';
        dropdown.style.zIndex = '999999';

        console.log('Dropdown abierto para memberId:', memberId);
    }
}

// Variables para almacenar datos del miembro a remover
let memberToRemove = {
    userId: null,
    memberName: null
};

// Función para abrir modal de confirmación de remover miembro
function removeMember(userId, memberName) {
    // Guardar datos del miembro
    memberToRemove.userId = userId;
    memberToRemove.memberName = memberName;

    // Actualizar el nombre en el modal
    const nameElement = document.getElementById('memberNameToRemove');
    if (nameElement) {
        nameElement.textContent = memberName;
    }

    // Mostrar el modal
    const modal = document.getElementById('confirmRemoveMemberModal');
    if (modal) {
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
    }
}

// Función para cerrar el modal de confirmación
function closeConfirmRemoveModal() {
    const modal = document.getElementById('confirmRemoveMemberModal');
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
    }

    // Limpiar datos
    memberToRemove.userId = null;
    memberToRemove.memberName = null;
}

// Función para confirmar y ejecutar la eliminación
function confirmRemoveMember() {
    if (!memberToRemove.userId) {
        console.error('No hay usuario seleccionado para remover');
        return;
    }

    console.log('Removiendo miembro:', memberToRemove);

    // Guardar el userId ANTES de cerrar el modal (que limpia memberToRemove)
    const userIdToRemove = memberToRemove.userId;
    const memberNameToRemove = memberToRemove.memberName;

    // Cerrar el modal de confirmación
    closeConfirmRemoveModal();

    // Mostrar loader en el body principal (no en modal)
    showMainLoader();

    // Preparar datos usando la variable local
    const formData = new FormData();
    formData.append('userId', userIdToRemove);

    console.log('FormData userId:', userIdToRemove);

    fetch('?route=clan_leader/remove-member', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
        .then(response => {
            console.log('Response status:', response.status);
            // Intentar leer el JSON incluso si hay error
            return response.json().then(data => {
                if (!response.ok) {
                    throw new Error(data.message || `HTTP error! status: ${response.status}`);
                }
                return data;
            });
        })
        .then(data => {
            console.log('Response data:', data);
            if (data.success) {
                // Ocultar loader y mostrar check
                hideMainLoader();
                showMainCheckAnimation();

                // Después de 3 segundos, recargar
                setTimeout(() => {
                    window.location.reload();
                }, 3000);
            } else {
                hideMainLoader();
                showCustomNotification(data.message || 'Error al remover miembro', 'error', 'Error');
            }
        })
        .catch(error => {
            console.error('Error completo:', error);
            hideMainLoader();
            showCustomNotification('Error: ' + error.message, 'error', 'Error');
        });
}

// Función para mostrar loader en el body principal
function showMainLoader() {
    const loader = document.createElement('div');
    loader.id = 'mainLoader';
    loader.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(15, 23, 42, 0.6); backdrop-filter: blur(10px); display: flex; align-items: center; justify-content: center; z-index: 10000;">
            <div style="background: rgba(252, 252, 253, 0.9); backdrop-filter: blur(40px); border-radius: 20px; padding: 40px; box-shadow: 0 8px 32px rgba(16, 185, 129, 0.04);">
                <img src="${window.APP_URL}/assets/img/Task_Loader.gif" alt="Loading" style="width: 120px; height: 120px;">
            </div>
        </div>
    `;
    document.body.appendChild(loader);
}

// Función para ocultar loader principal
function hideMainLoader() {
    const loader = document.getElementById('mainLoader');
    if (loader) {
        loader.remove();
    }
}

// Función para mostrar animación de check en el body principal
function showMainCheckAnimation() {
    const checkAnim = document.createElement('div');
    checkAnim.id = 'mainCheckAnimation';
    checkAnim.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(15, 23, 42, 0.6); backdrop-filter: blur(10px); display: flex; align-items: center; justify-content: center; z-index: 10001; animation: fadeIn 0.3s ease-in;">
            <div style="background: rgba(252, 252, 253, 0.95); backdrop-filter: blur(40px); border-radius: 20px; padding: 40px; box-shadow: 0 8px 32px rgba(16, 185, 129, 0.04); text-align: center;">
                <img src="${window.APP_URL}/assets/img/Check.gif" alt="Success" style="width: 150px; height: 150px;">
                <p style="margin-top: 20px; font-size: 1.2rem; font-weight: 600; color: #059669;">¡Miembro removido exitosamente!</p>
            </div>
        </div>
    `;
    document.body.appendChild(checkAnim);
}


// Funciones para el modal de agregar miembro
function openAddMemberModal() {
    console.log('Abriendo modal de agregar miembro...');
    const modal = document.getElementById('addMemberModal');
    if (!modal) {
        console.error('Modal no encontrado');
        return;
    }

    modal.style.display = 'flex';

    // Resetear el estado
    if (typeof userSearchInput !== 'undefined' && userSearchInput) userSearchInput.value = '';
    if (typeof userIdSelect !== 'undefined' && userIdSelect) userIdSelect.value = '';
    if (typeof selectedUserId !== 'undefined') selectedUserId = null;
    if (typeof allUsers !== 'undefined') allUsers = [];
    if (typeof userDropdown !== 'undefined' && userDropdown) {
        userDropdown.innerHTML = '';
        userDropdown.classList.remove('show');
    }

    // Cargar usuarios
    loadAvailableUsers();
}

function closeAddMemberModal() {
    const modal = document.getElementById('addMemberModal');
    if (modal) modal.style.display = 'none';

    if (typeof userSearchInput !== 'undefined' && userSearchInput) userSearchInput.value = '';
    if (typeof userIdSelect !== 'undefined' && userIdSelect) userIdSelect.value = '';
    if (typeof selectedUserId !== 'undefined') selectedUserId = null;
    if (typeof allUsers !== 'undefined') allUsers = [];
    if (typeof userDropdown !== 'undefined' && userDropdown) {
        userDropdown.innerHTML = '';
        userDropdown.classList.remove('show');
    }

    // Re-habilitar botones al cerrar
    enableModalButtons();
}

// Función para deshabilitar botones del modal
function disableModalButtons() {
    const cancelBtn = document.querySelector('.modal-footer-monday .btn-monday.btn-secondary');
    const addBtn = document.querySelector('.modal-footer-monday .btn-monday.btn-primary');

    if (cancelBtn) {
        cancelBtn.disabled = true;
        cancelBtn.style.opacity = '0.5';
        cancelBtn.style.cursor = 'not-allowed';
        cancelBtn.style.pointerEvents = 'none';
    }

    if (addBtn) {
        addBtn.disabled = true;
        addBtn.style.opacity = '0.5';
        addBtn.style.cursor = 'not-allowed';
        addBtn.style.pointerEvents = 'none';
    }
}

// Función para habilitar botones del modal
function enableModalButtons() {
    const cancelBtn = document.querySelector('.modal-footer-monday .btn-monday.btn-secondary');
    const addBtn = document.querySelector('.modal-footer-monday .btn-monday.btn-primary');

    if (cancelBtn) {
        cancelBtn.disabled = false;
        cancelBtn.style.opacity = '1';
        cancelBtn.style.cursor = 'pointer';
        cancelBtn.style.pointerEvents = 'auto';
    }

    if (addBtn) {
        addBtn.disabled = false;
        addBtn.style.opacity = '1';
        addBtn.style.cursor = 'pointer';
        addBtn.style.pointerEvents = 'auto';
    }
}

// Función para mostrar loader
function showLoader() {
    const modalBody = document.querySelector('.modal-body-monday');
    if (!modalBody) return;

    const loader = document.createElement('div');
    loader.id = 'memberLoader';
    loader.innerHTML = `
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(252, 252, 253, 0.9); backdrop-filter: blur(10px); display: flex; align-items: center; justify-content: center; z-index: 1000; border-radius: 12px;">
            <img src="${window.APP_URL}/assets/img/Task_Loader.gif" alt="Loading" style="width: 120px; height: 120px;">
        </div>
    `;
    modalBody.style.position = 'relative';
    modalBody.appendChild(loader);
}

// Función para ocultar loader
function hideLoader() {
    const loader = document.getElementById('memberLoader');
    if (loader) {
        loader.remove();
    }
}

// Función para mostrar animación de check
function showCheckAnimation() {
    const modalBody = document.querySelector('.modal-body-monday');
    if (!modalBody) return;

    const checkAnim = document.createElement('div');
    checkAnim.id = 'checkAnimation';
    checkAnim.innerHTML = `
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(252, 252, 253, 0.95); backdrop-filter: blur(10px); display: flex; flex-direction: column; align-items: center; justify-content: center; z-index: 1001; border-radius: 12px; animation: fadeIn 0.3s ease-in;">
            <img src="${window.APP_URL}/assets/img/Check.gif" alt="Success" style="max-width: 100%; height: auto;">
            <p style="margin-top: 20px; font-size: 1.1rem; font-weight: 600; color: #059669; animation: fadeIn 0.5s ease-in 0.3s both;">¡Miembro agregado exitosamente!</p>
        </div>
    `;
    modalBody.style.position = 'relative';
    modalBody.appendChild(checkAnim);
}

// Función para ocultar animación de check
function hideCheckAnimation() {
    const checkAnim = document.getElementById('checkAnimation');
    if (checkAnim) {
        checkAnim.style.animation = 'fadeOut 0.3s ease-out';
        setTimeout(() => {
            checkAnim.remove();
        }, 300);
    }
}


// Funciones para el modal de notificación personalizado
function showCustomNotification(message, type = 'info', title = 'Notificación') {
    const modal = document.getElementById('customNotificationModal');
    if (!modal) return;

    const titleElement = document.getElementById('notificationTitle');
    const messageElement = document.getElementById('notificationMessage');
    const iconElement = document.getElementById('notificationIcon');

    // Configurar el título
    if (titleElement) titleElement.textContent = title;

    // Configurar el mensaje
    if (messageElement) messageElement.textContent = message;

    // Configurar el icono según el tipo
    if (iconElement) {
        const iconContainer = iconElement.parentElement;
        if (iconContainer) iconContainer.className = 'custom-notification-icon ' + type;

        switch (type) {
            case 'success':
                iconElement.className = 'fas fa-check-circle';
                if (titleElement) titleElement.textContent = '¡Éxito!';
                break;
            case 'error':
                iconElement.className = 'fas fa-exclamation-circle';
                if (titleElement) titleElement.textContent = 'Error';
                break;
            case 'warning':
                iconElement.className = 'fas fa-exclamation-triangle';
                if (titleElement) titleElement.textContent = 'Advertencia';
                break;
            case 'info':
            default:
                iconElement.className = 'fas fa-info-circle';
                if (titleElement) titleElement.textContent = 'Información';
                break;
        }
    }

    // Mostrar el modal
    modal.style.display = 'flex';
}

function closeCustomNotification() {
    const modal = document.getElementById('customNotificationModal');
    if (!modal) return;

    const titleElement = document.getElementById('notificationTitle');
    const title = titleElement ? titleElement.textContent : '';

    // Si es un mensaje de éxito, cerrar también el modal de agregar miembro y recargar
    if (title === '¡Éxito!') {
        closeAddMemberModal();
        // Recargar la página para mostrar el nuevo miembro
        window.location.reload();
    } else {
        modal.style.display = 'none';
    }
}

// Función para realizar búsqueda con debounce
function performSearch(searchTerm) {
    console.log('performSearch llamado con:', searchTerm);

    // Limpiar timeout anterior
    if (searchTimeout) {
        clearTimeout(searchTimeout);
    }

    // Si el término está vacío, mostrar todos los miembros
    if (!searchTerm.trim()) {
        console.log('Término vacío, limpiando búsqueda');
        clearSearch();
        return;
    }

    console.log('Iniciando búsqueda para:', searchTerm);

    // Mostrar loading
    showSearchLoading(true);

    // Configurar timeout para evitar demasiadas peticiones
    searchTimeout = setTimeout(() => {
        console.log('Ejecutando búsqueda después del debounce');

        // Actualizar URL y recargar
        const url = new URL(window.location);
        url.searchParams.set('search', searchTerm.trim());
        url.searchParams.delete('page'); // Reset page when searching

        console.log('Redirigiendo a:', url.toString());
        window.location.href = url.toString();

    }, 800); // 800ms de debounce como en proyectos
}

// Función para limpiar búsqueda
function clearSearch() {
    const searchInput = document.getElementById('searchInput');
    const clearBtn = document.getElementById('clearSearch');

    searchInput.value = '';
    clearBtn.style.display = 'none';

    // Recargar la página sin parámetros de búsqueda
    const url = new URL(window.location);
    url.searchParams.delete('search');
    url.searchParams.delete('page');
    window.location.href = url.toString();
}

// Función para mostrar/ocultar loading
function showSearchLoading(show) {
    const loading = document.getElementById('searchLoading');
    if (loading) {
        loading.style.display = show ? 'flex' : 'none';
    }
}

// Variables globales
let userSearchInput, userDropdown, userIdSelect, allUsers = [], selectedUserId = null;

// Función para cargar usuarios disponibles
function loadAvailableUsers() {
    console.log('Cargando usuarios disponibles...');

    if (!userDropdown) {
        console.error('userDropdown no está definido');
        return;
    }

    // Mostrar estado de carga
    userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;"><i class="fas fa-spinner fa-spin"></i> Cargando usuarios...</div>';
    userDropdown.classList.add('show');

    fetch('?route=clan_leader/get-available-users')
        .then(response => {
            console.log('Respuesta del servidor:', response.status);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Datos recibidos:', data);
            if (data.success) {
                allUsers = data.users;
                console.log('Usuarios cargados:', allUsers.length);
                renderUserDropdown(allUsers);
            } else {
                console.error('Error al cargar usuarios:', data.message);
                userDropdown.innerHTML = '<div class="dropdown-item" style="color: #ef4444; cursor: default;"><i class="fas fa-exclamation-triangle"></i> ' + (data.message || 'Error al cargar usuarios') + '</div>';
                userDropdown.classList.add('show');
            }
        })
        .catch(error => {
            console.error('Error de red:', error);
            userDropdown.innerHTML = '<div class="dropdown-item" style="color: #ef4444; cursor: default;"><i class="fas fa-wifi"></i> Error de conexión</div>';
            userDropdown.classList.add('show');
        });
}

// Función para renderizar el dropdown de usuarios
function renderUserDropdown(users) {
    console.log('Renderizando dropdown con', users.length, 'usuarios');
    if (!userDropdown) return;

    userDropdown.innerHTML = '';

    if (!users || users.length === 0) {
        userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;">No hay usuarios disponibles</div>';
        userDropdown.classList.add('show');
        return;
    }

    users.forEach(user => {
        const item = document.createElement('div');
        item.className = 'dropdown-item';
        item.dataset.userId = user.user_id;

        // Generar inicial (solo primera letra)
        const fullName = user.full_name || 'Sin nombre';
        const initial = fullName.charAt(0).toUpperCase();

        // Crear avatar
        let avatarHtml = '';
        if (user.avatar_path && user.avatar_path !== '') {
            avatarHtml = `
                <img src="${APP_URL}${user.avatar_path}"
                     alt="${fullName}"
                     class="dropdown-avatar-image"
                     onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                <div class="dropdown-avatar-initials" style="display: none;" data-user-id="${user.user_id}">
                    ${initial}
                </div>
            `;
        } else {
            avatarHtml = `
                <div class="dropdown-avatar-initials" data-user-id="${user.user_id}">
                    ${initial}
                </div>
            `;
        }

        item.innerHTML = `
            <div class="dropdown-user-avatar">
                ${avatarHtml}
            </div>
            <div class="user-info">
                <div class="user-name">${fullName}</div>
                <div class="user-email">${user.email || 'Sin email'}</div>
            </div>
        `;

        item.addEventListener('click', function () {
            selectUser(user);
        });

        userDropdown.appendChild(item);
    });

    userDropdown.classList.add('show');
}

// Función para seleccionar un usuario
function selectUser(user) {
    selectedUserId = user.user_id;
    if (userSearchInput) userSearchInput.value = `${user.full_name} (${user.email})`;
    if (userDropdown) userDropdown.classList.remove('show');

    // Actualizar el select oculto
    if (userIdSelect) userIdSelect.value = user.user_id;

    // Marcar como seleccionado en el dropdown
    document.querySelectorAll('.dropdown-item').forEach(item => {
        item.classList.remove('selected');
        if (item.dataset.userId == user.user_id) {
            item.classList.add('selected');
        }
    });
}

// Función movida fuera del DOMContentLoaded

// Función movida fuera del DOMContentLoaded

// Función movida fuera del DOMContentLoaded

// Funciones ya definidas al inicio del script

// Exponer funciones al objeto global para compatibilidad con atributos inline
window.goToPage = goToPage;
window.toggleListMenu = toggleListMenu;
window.removeMember = removeMember;
window.closeConfirmRemoveModal = closeConfirmRemoveModal;
window.confirmRemoveMember = confirmRemoveMember;
window.openAddMemberModal = openAddMemberModal;
window.closeAddMemberModal = closeAddMemberModal;
window.showCustomNotification = showCustomNotification;
window.closeCustomNotification = closeCustomNotification;
window.loadAvailableUsers = loadAvailableUsers;
window.renderUserDropdown = renderUserDropdown;
window.selectUser = selectUser;
window.performSearch = performSearch;
window.clearSearch = clearSearch;
window.showSearchLoading = showSearchLoading;

document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById('searchInput');
    const clearBtn = document.getElementById('clearSearch');

    // Inicializar variables del modal
    userSearchInput = document.getElementById('userSearch');
    userDropdown = document.getElementById('userDropdown');
    userIdSelect = document.getElementById('userId');

    // Evento para búsqueda en tiempo real
    searchInput.addEventListener('input', function (e) {
        const searchTerm = e.target.value;
        console.log('Input event disparado:', searchTerm);

        // Mostrar/ocultar botón limpiar
        if (searchTerm.trim()) {
            clearBtn.style.display = 'block';
        } else {
            clearBtn.style.display = 'none';
        }

        // Realizar búsqueda
        performSearch(searchTerm);
    });

    // Evento para botón limpiar
    clearBtn.addEventListener('click', function () {
        clearSearch();
    });

    // Mostrar botón limpiar si hay búsqueda inicial
    if (searchInput.value.trim()) {
        clearBtn.style.display = 'block';
    }

    // Manejar navegación del navegador (atrás/adelante)
    window.addEventListener('popstate', function (e) {
        const urlParams = new URLSearchParams(window.location.search);
        const searchParam = urlParams.get('search') || '';
        searchInput.value = searchParam;

        if (searchParam.trim()) {
            clearBtn.style.display = 'block';
            performSearch(searchParam);
        } else {
            clearBtn.style.display = 'none';
            // Recargar página para mostrar todos los miembros
            window.location.reload();
        }
    });

    // Hacer la función clearSearch global
    window.clearSearch = clearSearch;

    // Función movida fuera del DOMContentLoaded

    // Cerrar dropdowns al hacer clic fuera
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.dropdown-container') && !e.target.closest('.btn-list-action')) {
            document.querySelectorAll('.dropdown-menu-list').forEach(menu => {
                menu.style.display = 'none';
            });
        }
    });

    // Prevenir que el dropdown se cierre al hacer clic dentro de él
    document.addEventListener('click', function (e) {
        if (e.target.closest('.dropdown-menu-list')) {
            e.stopPropagation();
        }
    });

    // Aplicar filtro inicial si hay búsqueda previa
    if (searchInput.value) {
        filterMembers(searchInput.value);
    }

    // Funcionalidad del buscador de usuarios en el modal ya inicializada arriba

    // Función movida fuera del DOMContentLoaded

    // Función movida fuera del DOMContentLoaded

    // Función movida fuera del DOMContentLoaded

    // Event listeners para el buscador de usuarios
    userSearchInput.addEventListener('input', function () {
        const searchTerm = this.value.toLowerCase().trim();
        console.log('Buscando:', searchTerm);

        if (searchTerm.length === 0) {
            renderUserDropdown(allUsers);
            selectedUserId = null;
            userIdSelect.value = '';
        } else if (selectedUserId && this.value.includes('(')) {
            // Si el usuario ya está seleccionado, no filtrar
            return;
        } else {
            // Filtrar usuarios
            const filteredUsers = allUsers.filter(user => {
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();
                const username = (user.username || '').toLowerCase();

                return fullName.includes(searchTerm) ||
                    email.includes(searchTerm) ||
                    username.includes(searchTerm);
            });

            console.log('Usuarios filtrados:', filteredUsers.length);

            // Si hay exactamente un usuario que coincide perfectamente, seleccionarlo automáticamente
            if (filteredUsers.length === 1) {
                const user = filteredUsers[0];
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();

                // Verificar si el término de búsqueda coincide exactamente con el nombre o email
                if (fullName === searchTerm || email === searchTerm ||
                    fullName.includes(searchTerm) && searchTerm.length >= 3) {
                    console.log('Selección automática de usuario:', user.full_name);
                    selectUser(user);
                    return;
                }
            }

            renderUserDropdown(filteredUsers);
        }
    });

    userSearchInput.addEventListener('focus', function () {
        if (allUsers.length > 0) {
            userDropdown.classList.add('show');
        } else {
            // Mostrar estado de carga si aún no se han cargado los usuarios
            userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;">Cargando usuarios...</div>';
            userDropdown.classList.add('show');
        }
    });

    // Manejar la tecla Enter para seleccionar el primer usuario disponible
    userSearchInput.addEventListener('keydown', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault();

            // Buscar usuarios que coincidan con el término actual
            const searchTerm = this.value.toLowerCase().trim();
            const filteredUsers = allUsers.filter(user => {
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();
                const username = (user.username || '').toLowerCase();

                return fullName.includes(searchTerm) ||
                    email.includes(searchTerm) ||
                    username.includes(searchTerm);
            });

            // Si hay usuarios filtrados, seleccionar el primero
            if (filteredUsers.length > 0) {
                selectUser(filteredUsers[0]);
            } else if (searchTerm.length >= 3) {
                // Si no hay coincidencias pero el término es largo, buscar coincidencias parciales
                const partialMatches = allUsers.filter(user => {
                    const fullName = (user.full_name || '').toLowerCase();
                    const email = (user.email || '').toLowerCase();

                    return fullName.startsWith(searchTerm) || email.startsWith(searchTerm);
                });

                if (partialMatches.length > 0) {
                    selectUser(partialMatches[0]);
                } else {
                    showCustomNotification('No se encontró un usuario que coincida con "' + searchTerm + '"', 'warning', 'Usuario no encontrado');
                }
            } else {
                showCustomNotification('Escribe al menos 3 caracteres para buscar usuarios', 'info', 'Búsqueda requerida');
            }
        }
    });

    // Cerrar dropdown al hacer clic fuera
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.select-search-container')) {
            userDropdown.classList.remove('show');
        }
    });

    // Funciones movidas fuera del DOMContentLoaded

    // Funciones movidas fuera del DOMContentLoaded

    // Cerrar modal de notificación con tecla Escape
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            const notificationModal = document.getElementById('customNotificationModal');
            if (notificationModal.style.display === 'flex') {
                closeCustomNotification();
            }
        }
    });

    // Validación personalizada del formulario
    document.getElementById('addMemberForm').addEventListener('submit', function (e) {
        e.preventDefault();

        console.log('Validando formulario de agregar miembro...');
        console.log('selectedUserId:', selectedUserId);
        console.log('userIdSelect.value:', userIdSelect.value);
        console.log('userSearchInput.value:', userSearchInput.value);

        // Validar que se haya seleccionado un usuario
        if (!selectedUserId || userIdSelect.value === '') {
            // Intentar encontrar el usuario basado en el texto del input
            const searchTerm = userSearchInput.value.trim();
            if (searchTerm.length >= 3) {
                const foundUser = allUsers.find(user => {
                    const fullName = (user.full_name || '').toLowerCase();
                    const email = (user.email || '').toLowerCase();
                    const displayText = `${user.full_name} (${user.email})`.toLowerCase();

                    return fullName === searchTerm.toLowerCase() ||
                        email === searchTerm.toLowerCase() ||
                        displayText === searchTerm.toLowerCase() ||
                        fullName.includes(searchTerm.toLowerCase());
                });

                if (foundUser) {
                    console.log('Usuario encontrado automáticamente:', foundUser.full_name);
                    selectUser(foundUser);
                    // Continuar con el envío del formulario
                } else {
                    showCustomNotification('Por favor selecciona un usuario válido de la lista o escribe al menos 3 caracteres y presiona Enter', 'warning', 'Usuario requerido');
                    userSearchInput.focus();
                    return false;
                }
            } else {
                showCustomNotification('Por favor selecciona un usuario para agregar al clan o escribe al menos 3 caracteres y presiona Enter', 'warning', 'Usuario requerido');
                userSearchInput.focus();
                return false;
            }
        }

        console.log('Enviando formulario con userId:', selectedUserId);
        console.log('userIdSelect.value:', userIdSelect.value);

        // Deshabilitar botones para evitar doble clic
        disableModalButtons();

        // Mostrar loader
        showLoader();

        // Preparar los datos del formulario
        const formData = new FormData();
        formData.append('userId', selectedUserId);

        // También asegurar que el select oculto tenga el valor correcto
        userIdSelect.value = selectedUserId;

        console.log('Datos a enviar:', {
            userId: selectedUserId,
            userIdSelectValue: userIdSelect.value,
            url: '?route=clan_leader/add-member'
        });

        // Verificar que los datos se están enviando correctamente
        for (let pair of formData.entries()) {
            console.log('FormData:', pair[0] + ': ' + pair[1]);
        }

        fetch('?route=clan_leader/add-member', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
            .then(response => {
                console.log('Respuesta del servidor:', response.status, response.statusText);
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                console.log('Datos recibidos:', data);
                if (data.success) {
                    // Ocultar loader y mostrar animación de check
                    hideLoader();
                    showCheckAnimation();

                    // Después de 3 segundos, cerrar modal y recargar
                    setTimeout(() => {
                        hideCheckAnimation();
                        closeAddMemberModal();
                        window.location.reload();
                    }, 3000);
                } else {
                    hideLoader();
                    enableModalButtons(); // Re-habilitar botones en caso de error
                    showCustomNotification('Error al agregar usuario: ' + (data.message || 'Error desconocido'), 'error', 'Error');
                }
            })
            .catch(error => {
                console.error('Error completo:', error);
                hideLoader();
                enableModalButtons(); // Re-habilitar botones en caso de error
                showCustomNotification('Error de conexión al agregar usuario: ' + error.message, 'error', 'Error de conexión');
            });
    });

    // Función movida fuera del DOMContentLoaded

    // Función removeMember ya definida arriba (duplicado eliminado)

    // Funciones ya definidas arriba (duplicado eliminado)
});
