<?php
/**
 * Script para agregar campo de teléfono a la tabla Users
 * Ejecutar una sola vez: http://rinotrack.rinorisk.com/desarrollo/rinotrack/public/add_phone_field.php
 */

require_once __DIR__ . '/../config/database.php';

try {
    $db = Database::getConnection();
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Agregando campo de teléfono a la tabla Users...</h2>\n";
    
    // 1. Verificar si la columna ya existe
    echo "<p>1. Verificando si la columna 'phone' ya existe...</p>\n";
    $stmt = $db->query("SHOW COLUMNS FROM Users LIKE 'phone'");
    $columnExists = $stmt->rowCount() > 0;
    
    if ($columnExists) {
        echo "<p style='color: orange;'>⚠️ La columna 'phone' ya existe en la tabla Users</p>\n";
    } else {
        // 2. Agregar columna phone
        echo "<p>2. Agregando columna 'phone' a la tabla Users...</p>\n";
        $sql = "ALTER TABLE Users ADD COLUMN phone VARCHAR(20) NULL AFTER email";
        $db->exec($sql);
        echo "<p style='color: green;'>✓ Columna 'phone' agregada exitosamente</p>\n";
    }
    
    // 3. Actualizar teléfono del usuario desarrollo@rinorisk.com
    echo "<p>3. Actualizando teléfono del usuario desarrollo@rinorisk.com...</p>\n";
    $stmt = $db->prepare("UPDATE Users SET phone = ? WHERE email = ?");
    $stmt->execute(['6631231673', 'desarrollo@rinorisk.com']);
    echo "<p style='color: green;'>✓ Teléfono actualizado exitosamente</p>\n";
    
    // 4. Verificar el cambio
    echo "<p>4. Verificando cambios...</p>\n";
    $stmt = $db->prepare("SELECT user_id, username, email, phone, full_name FROM Users WHERE email = ?");
    $stmt->execute(['desarrollo@rinorisk.com']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo "<table border='1' style='border-collapse: collapse; margin-top: 10px;'>";
        echo "<tr><th>Campo</th><th>Valor</th></tr>";
        foreach ($user as $key => $value) {
            echo "<tr><td><strong>{$key}</strong></td><td>{$value}</td></tr>";
        }
        echo "</table>";
    }
    
    echo "<h3 style='color: green;'>✅ Migración completada exitosamente</h3>\n";
    
    // 5. Mostrar estructura actualizada de la tabla Users
    echo "<h3>Estructura actualizada de la tabla Users:</h3>\n";
    $stmt = $db->query("DESCRIBE Users");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($columns as $column) {
        $highlight = $column['Field'] === 'phone' ? "style='background-color: #90EE90;'" : "";
        echo "<tr {$highlight}>";
        echo "<td>{$column['Field']}</td>";
        echo "<td>{$column['Type']}</td>";
        echo "<td>{$column['Null']}</td>";
        echo "<td>{$column['Key']}</td>";
        echo "<td>" . ($column['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>\n";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>



