#!/bin/bash

# Script para arreglar permisos de uploads en el servidor
# Uso: ./fix-uploads-permissions.sh [desarrollo|produccion]

set -e

# Colores
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

# Configuración
REMOTE_USER="bitnami"
REMOTE_HOST="52.3.160.124"
LOCAL_PATH="/Users/abdiel/Documents/Proyectos/htdocs/rinotrackalfa"
PEM_FILE="$LOCAL_PATH/rinotrack.pem"

# Determinar la ruta según el argumento
ENVIRONMENT=${1:-desarrollo}

if [ "$ENVIRONMENT" = "desarrollo" ]; then
    REMOTE_PATH="/home/bitnami/htdocs/desarrollo/rinotrack"
    ENV_NAME="DESARROLLO"
elif [ "$ENVIRONMENT" = "produccion" ]; then
    REMOTE_PATH="/home/bitnami/htdocs/rinotrackalfa"
    ENV_NAME="PRODUCCIÓN"
else
    echo -e "${RED}❌ Argumento inválido. Uso: ./fix-uploads-permissions.sh [desarrollo|produccion]${NC}"
    exit 1
fi

echo -e "${BLUE}🔧 Arreglando permisos de uploads en $ENV_NAME...${NC}"

# Verificar que el archivo PEM existe
if [ ! -f "$PEM_FILE" ]; then
    echo -e "${RED}❌ Error: No se encuentra el archivo rinotrack.pem${NC}"
    exit 1
fi

# Verificar permisos del archivo PEM
chmod 400 "$PEM_FILE"

# Función para ejecutar comandos SSH
ssh_exec() {
    ssh -i "$PEM_FILE" -o StrictHostKeyChecking=no "$REMOTE_USER@$REMOTE_HOST" "$1"
}

echo -e "${YELLOW}📋 Verificando usuario de PHP-FPM...${NC}"
ssh_exec "ps aux | grep php-fpm | grep -v grep | head -3"

echo -e "${YELLOW}📂 Permisos ANTES del cambio:${NC}"
ssh_exec "ls -la $REMOTE_PATH/public/uploads/ | head -10"

echo -e "${YELLOW}🔧 Aplicando permisos correctos...${NC}"
ssh_exec "
    cd $REMOTE_PATH
    
    # Crear directorio si no existe
    mkdir -p public/uploads/task_attachments
    
    # Cambiar propietario y grupo (bitnami:daemon)
    # daemon es el usuario que ejecuta PHP-FPM
    sudo chown -R bitnami:daemon public/uploads
    
    # Directorios: 775 (rwxrwxr-x)
    # Permite a bitnami y daemon crear/modificar archivos y subdirectorios
    sudo chmod 775 public/uploads
    sudo find public/uploads -type d -exec chmod 775 {} \;
    
    # Archivos: 664 (rw-rw-r--)
    # Permite a bitnami y daemon leer/escribir archivos
    sudo find public/uploads -type f -exec chmod 664 {} \;
    
    echo '✅ Permisos aplicados correctamente'
"

echo -e "${YELLOW}📂 Permisos DESPUÉS del cambio:${NC}"
ssh_exec "ls -la $REMOTE_PATH/public/uploads/ | head -10"

echo -e "${YELLOW}📂 Verificando subdirectorio task_attachments:${NC}"
ssh_exec "ls -ld $REMOTE_PATH/public/uploads/task_attachments/"

echo -e "${GREEN}✅ Permisos actualizados exitosamente en $ENV_NAME!${NC}"
echo -e "${BLUE}📊 Configuración aplicada:${NC}"
echo -e "   • Propietario: bitnami:daemon"
echo -e "   • Directorios: 775 (rwxrwxr-x)"
echo -e "   • Archivos: 664 (rw-rw-r--)"
echo -e ""
echo -e "${GREEN}✨ PHP podrá crear, modificar y eliminar archivos en uploads/${NC}"

