#!/bin/bash

# Script de auto-despliegue para desarrollo
# Se ejecuta automáticamente cuando se detectan cambios

set -e

# Configuración
REMOTE_USER="bitnami"
REMOTE_HOST="52.3.160.124"
REMOTE_PATH="/home/bitnami/htdocs/rinotrackalfa"
LOCAL_PATH="/Users/abdiel/Documents/Proyectos/htdocs/rinotrackalfa"
PEM_FILE="$LOCAL_PATH/rinotrack.pem"

# Colores
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}🔄 Auto-despliegue iniciado...${NC}"

# Función para despliegue rápido (solo archivos modificados)
quick_deploy() {
    echo -e "${YELLOW}📤 Sincronizando cambios...${NC}"
    
    rsync -avz \
        -e "ssh -i $PEM_FILE -o StrictHostKeyChecking=no" \
        --exclude='.git' \
        --exclude='node_modules' \
        --exclude='.DS_Store' \
        --exclude='*.log' \
        --exclude='rinotrack.pem' \
        --exclude='deploy.sh' \
        --exclude='auto-deploy.sh' \
        --exclude='.env' \
        "$LOCAL_PATH/" "$REMOTE_USER@$REMOTE_HOST:$REMOTE_PATH/"
    
    # Fijar permisos correctos en carpeta de uploads después del despliegue
    echo -e "${YELLOW}🔧 Configurando permisos de uploads...${NC}"
    ssh -i "$PEM_FILE" "$REMOTE_USER@$REMOTE_HOST" "sudo chown -R bitnami:daemon $REMOTE_PATH/public/uploads && sudo chmod -R 775 $REMOTE_PATH/public/uploads"
    
    echo -e "${GREEN}✅ Cambios desplegados automáticamente${NC}"
    echo -e "${BLUE}🌐 URL: http://52.3.160.124/rinotrackalfa/public/${NC}"
}

# Ejecutar despliegue rápido
quick_deploy
