<?php
// Capturar el contenido de la vista
ob_start();
?>

<style>
/* CSS crítico inline para evitar problemas de caché */
body.login-page {
    margin: 0;
    padding: 0;
    font-family: 'Open Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
    min-height: 100vh !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    font-size: 62.5% !important;
    overflow: hidden !important;
}
.cont {
    display: flex !important;
    justify-content: center !important;
    align-items: center !important;
    height: 100% !important;
    width: 100% !important;
    background-image: url('assets/img/login.jpg') !important;
    background-size: cover !important;
    background-position: center !important;
    background-repeat: no-repeat !important;
    position: fixed !important;
    top: 0 !important;
    left: 0 !important;
}
.cont::before {
    content: '' !important;
    position: absolute !important;
    top: 0 !important;
    left: 0 !important;
    right: 0 !important;
    bottom: 0 !important;
    background: linear-gradient(135deg, rgba(30, 58, 138, 0.85) 0%, rgba(30, 64, 175, 0.75) 50%, rgba(59, 130, 246, 0.7) 100%) !important;
}
</style>

<div class="cont">
    <div class="demo">
        <div class="login" id="loginScreen">
            <div class="login__check"></div>
            <div class="login__form">
                <div class="login__header">
                    <svg class="login__logo" viewBox="0 0 100 100">
                        <path d="M50,15 L61,35 L83,38 L66.5,54 L70,76 L50,65 L30,76 L33.5,54 L17,38 L39,35 Z" fill="white" stroke="white" stroke-width="2"/>
                    </svg>
                    <h1 class="login__title"><?php echo APP_NAME; ?></h1>
                    <p class="login__subtitle">Tu estrella guía</p>
                </div>
                
                <form id="loginForm">
                    <div class="login__row">
                        <svg class="login__icon name svg-icon" viewBox="0 0 20 20">
                            <path d="M0,20 a10,8 0 0,1 20,0z M10,0 a4,4 0 0,1 0,8 a4,4 0 0,1 0,-8" />
                        </svg>
                        <input type="text" class="login__input name" id="username" name="username" placeholder="Usuario o Email" required/>
                    </div>
                    
                    <div class="login__row">
                        <svg class="login__icon pass svg-icon" viewBox="0 0 20 20">
                            <path d="M0,20 20,20 20,8 0,8z M10,13 10,16z M4,8 a6,8 0 0,1 12,0" />
                        </svg>
                        <input type="password" class="login__input pass" id="password" name="password" placeholder="Contraseña" required/>
                        <i class="fas fa-eye toggle-password" id="togglePassword"></i>
                    </div>
                    
                    <button type="submit" class="login__submit" id="loginBtn">
                        <span class="btn-text">Iniciar Sesión</span>
                    </button>
                    
                    <div class="login__message" id="loginMessage"></div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
// Guardar el contenido en una variable
$content = ob_get_clean();

// Configurar variables para el layout
$title = APP_NAME . ' - Iniciar Sesión';
$isLogin = true; // Variable para que el layout sepa que es la página de login

// Incluir el layout principal
include __DIR__ . '/layout.php';
?>