<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title ?? APP_NAME; ?></title>
    
    <!-- Prevenir flash de contenido sin estilo (FOUC) para sidebar colapsado -->
    <script>
        // Ejecutar ANTES de que se renderice la página para evitar flash visual
        (function() {
            const savedState = localStorage.getItem('sidebarCollapsed');
            if (savedState === 'true') {
                // Agregar clase al html ANTES de que se renderice
                document.documentElement.classList.add('sidebar-collapsed');
            }
        })();
    </script>
    
    <!-- Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo Utils::asset('polaris/apple-touch-icon.png'); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo Utils::asset('polaris/favicon-32x32.png'); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo Utils::asset('polaris/favicon-16x16.png'); ?>">
    <link rel="manifest" href="<?php echo Utils::asset('polaris/site.webmanifest'); ?>">
    <link rel="shortcut icon" href="<?php echo Utils::asset('polaris/favicon.ico'); ?>">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php 
    // No cargar theme.css en login para evitar conflictos
    $isLoginPageForCSS = (isset($isLogin) && $isLogin === true);
    if (!$isLoginPageForCSS): ?>
    <link rel="stylesheet" href="<?php echo Utils::asset('assets/css/theme.css'); ?>?v=<?php echo time(); ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo Utils::asset('assets/css/styles.css'); ?>?v=<?php echo time(); ?>">
    <?php if (!$isLoginPageForCSS): ?>
    <link rel="stylesheet" href="<?php echo Utils::asset('assets/css/sidebar.css'); ?>?v=<?php echo time(); ?>">
    <?php endif; ?>
    <?php if (isset($additionalCSS)): ?>
        <?php foreach ($additionalCSS as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- JavaScript crítico en el head -->
    <?php if (isset($additionalJS)): ?>
        <?php foreach ($additionalJS as $js): ?>
            <script src="<?php echo $js; ?>" defer></script>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- Script de emergencia para deleteClan -->
    <script>
    // Función deleteClan de emergencia - disponible globalmente
    window.deleteClan = function(clanId) {
        if (confirm("¿Estás seguro de que quieres eliminar este clan? Esta acción no se puede deshacer.")) {
            const formData = new FormData();
            formData.append("clanId", clanId);
            
            fetch("?route=admin/delete-clan", {
                method: "POST",
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("Clan eliminado exitosamente");
                    location.reload();
                } else {
                    alert(data.message || "Error al eliminar el clan");
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Error de conexión al eliminar el clan");
            });
        }
    };
    
    // console.log("✅ Función deleteClan cargada desde layout global");
    </script>
</head>
<body<?php 
    $routeTmp = $_GET['route'] ?? '';
    $isLeaderTmp = (isset($currentPage) && $currentPage === 'clan_leader') || (strpos($routeTmp, 'clan_leader') === 0);
    // Detectar página de login: variable explícita o por ruta
    // IMPORTANTE: La ruta vacía ('') puede ser dashboard o login, así que solo considerar login si no hay usuario
    $isLoginPage = (isset($isLogin) && $isLogin === true) || $routeTmp === 'login' || $routeTmp === 'process-login' || ((!isset($routeTmp) || $routeTmp === '') && !isset($user));
    // Detectar si es Dashboard
    $isDashboardPage = (!$isLoginPage && isset($user) && ($routeTmp === 'dashboard' || $routeTmp === '' || $routeTmp === null));
    
    $bodyClasses = [];
    // Ya no usamos has-leader-nav porque el sidebar unificado lo reemplaza
    if ($isLoginPage) $bodyClasses[] = 'login-page';
    // Eliminado dashboard-page - no se necesita clase especial
    
    echo !empty($bodyClasses) ? ' class="' . implode(' ', $bodyClasses) . '"' : '';
?>>
    <?php 
    // Incluir sidebar solo si no es página de login Y hay usuario
    // El sidebar debe mostrarse siempre que haya un usuario autenticado, incluso en dashboard
    if (!$isLoginPage && isset($user)):
        require_once __DIR__ . '/components/sidebar.php';
    endif;
    
    // NOTA: Los menús duplicados (modern-nav y leader-nav) han sido ocultados
    // Todas las vistas ahora usan el sidebar unificado (main-sidebar)
    
    echo $content ?? '';
    ?>
    
    <script src="<?php echo Utils::asset('assets/js/script.js'); ?>"></script>
    
    <?php if (!$isLoginPage && isset($user)): ?>
    <!-- Script unificado para el sidebar - se carga en todas las vistas -->
    <script src="<?php echo Utils::asset('assets/js/sidebar.js'); ?>"></script>
    <?php endif; ?>
</body>
</html>