<?php
/**
 * Componente de Sidebar Reutilizable
 * Detecta automáticamente el tipo de usuario y muestra el menú apropiado
 */

// Si no hay usuario, no mostrar sidebar
if (!isset($user) || !$user) {
    error_log('⚠️ Sidebar: Usuario no definido o vacío');
    return;
}

// Detectar tipo de usuario basado en la ruta actual y roles
$route = $_GET['route'] ?? '';
$roleModel = new Role();
$userRole = null;
$userRoleName = null;

if (isset($user['user_id'])) {
    $userRole = $roleModel->getUserRole($user['user_id']);
    $userRoleName = $userRole['role_name'] ?? null;
}

// Determinar tipo de página
$isAdminPage = strpos($route, 'admin') === 0;
$isLeaderPage = strpos($route, 'clan_leader') === 0;
$isMemberPage = strpos($route, 'clan_member') === 0;
$isKPIPage = strpos($route, 'kpi') === 0;
// IMPORTANTE: Solo considerar login si la ruta es explícitamente 'login' o 'process-login'
// La ruta vacía ('') puede ser dashboard si hay usuario autenticado
$isLoginPage = ($route === 'login' || $route === 'process-login');

// Obtener avatar del usuario
$avatar = $user['avatar_path'] ?? ($user['profile_picture'] ?? '');
$userInitial = strtoupper(substr($user['full_name'] ?? ($user['username'] ?? 'U'), 0, 1));
$userName = $user['full_name'] ?? $user['username'] ?? 'Usuario';
$userRoleDisplay = 'Usuario';

if ($userRoleName === Role::SUPER_ADMIN || $userRoleName === Role::ADMIN) {
    $userRoleDisplay = 'Administrador';
} elseif ($userRoleName === Role::LIDER_CLAN) {
    $userRoleDisplay = 'Líder de Clan';
} elseif ($userRoleName === Role::USUARIO_NORMAL) {
    $userRoleDisplay = 'Miembro de Clan';
}

// Si es página de login, no mostrar sidebar
if ($isLoginPage) {
    error_log('⚠️ Sidebar: Es página de login, no se muestra');
    return;
}

// Log de debug para verificar que el sidebar se está renderizando
error_log('✅ Sidebar renderizando para ruta: ' . $route . ', usuario: ' . ($userName ?? 'N/A'));
?>

<!-- Sidebar -->
<aside class="main-sidebar" id="mainSidebar">
    <!-- Header del Sidebar -->
    <div class="sidebar-header">
        <div class="sidebar-brand">
            <div class="sidebar-logo">
                <i class="fas fa-star"></i>
            </div>
            <span class="sidebar-title">Polaris<br><span class="sidebar-subtitle">by Rinorisk</span></span>
        </div>
    </div>

    <?php
    // Obtener clanes del usuario (si tiene múltiples)
    $auth = new Auth();
    $clanModel = new Clan();
    $userClans = [];
    $activeClanId = null;
    
    if (isset($user['user_id'])) {
        $userClans = $clanModel->getUserClans($user['user_id']);
        $activeClanId = $auth->getActiveClanId();
    }
    
    // Mostrar selector de clan solo si tiene más de un clan
    if (count($userClans) > 1): ?>
    <!-- Selector de Clan -->
    <div class="clan-selector">
        <div class="clan-selector-header">
            <i class="fas fa-users-cog"></i>
            <span>CONTENEDOR ACTIVO</span>
        </div>
        <select id="clanSelectorDropdown" class="clan-dropdown">
            <?php foreach ($userClans as $userClan): ?>
                <option value="<?php echo $userClan['clan_id']; ?>" 
                        <?php echo ($userClan['clan_id'] == $activeClanId) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($userClan['clan_name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <?php endif; ?>

    <!-- Navegación del Sidebar -->
    <nav class="sidebar-nav">
        <?php if ($isAdminPage || ($userRoleName === Role::SUPER_ADMIN || $userRoleName === Role::ADMIN)): ?>
            <!-- Menú de Administrador -->
            <a href="?route=dashboard" class="sidebar-link <?php echo ($route === 'dashboard' || $route === '') ? 'active' : ''; ?>">
                <i class="fas fa-home"></i>
                <span class="sidebar-link-text">Dashboard</span>
            </a>
            <a href="?route=admin" class="sidebar-link <?php echo ($route === 'admin') ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i>
                <span class="sidebar-link-text">Admin Panel</span>
            </a>
            <a href="?route=admin/users" class="sidebar-link <?php echo ($route === 'admin/users') ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                <span class="sidebar-link-text">Usuarios</span>
            </a>
            <a href="?route=admin/projects" class="sidebar-link <?php echo ($route === 'admin/projects') ? 'active' : ''; ?>">
                <i class="fas fa-project-diagram"></i>
                <span class="sidebar-link-text">Proyectos</span>
            </a>
            <a href="?route=admin/tasks" class="sidebar-link <?php echo ($route === 'admin/tasks') ? 'active' : ''; ?>">
                <i class="fas fa-tasks"></i>
                <span class="sidebar-link-text">Tareas</span>
            </a>
            <a href="?route=admin/clans" class="sidebar-link <?php echo ($route === 'admin/clans') ? 'active' : ''; ?>">
                <i class="fas fa-users-cog"></i>
                <span class="sidebar-link-text">Clanes</span>
            </a>
            <a href="?route=admin/notifications" class="sidebar-link <?php echo ($route === 'admin/notifications') ? 'active' : ''; ?>">
                <i class="fas fa-bell"></i>
                <span class="sidebar-link-text">Notificaciones</span>
            </a>
            <a href="?route=kpi/dashboard" class="sidebar-link <?php echo ($isKPIPage) ? 'active' : ''; ?>">
                <i class="fas fa-chart-line"></i>
                <span class="sidebar-link-text">KPIs</span>
            </a>
            
        <?php elseif ($isLeaderPage || $userRoleName === Role::LIDER_CLAN): ?>
            <!-- Menú de Líder de Clan -->
            <a href="?route=clan_leader" class="sidebar-link <?php echo ($route === 'clan_leader' || $route === 'clan_leader/dashboard') ? 'active' : ''; ?>">
                <i class="fas fa-home"></i>
                <span class="sidebar-link-text">Dashboard</span>
            </a>
            <a href="?route=clan_leader/members" class="sidebar-link <?php echo ($route === 'clan_leader/members') ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                <span class="sidebar-link-text">Miembros</span>
            </a>
            <a href="?route=clan_leader/projects" class="sidebar-link <?php echo ($route === 'clan_leader/projects') ? 'active' : ''; ?>">
                <i class="fas fa-folder"></i>
                <span class="sidebar-link-text">Proyectos</span>
            </a>
            <a href="?route=clan_leader/tasks" class="sidebar-link <?php echo (strpos($route, 'clan_leader/tasks') === 0 || $route === 'clan_leader/get-task-details') ? 'active' : ''; ?>">
                <i class="fas fa-tasks"></i>
                <span class="sidebar-link-text">Tareas</span>
            </a>
            <a href="?route=clan_leader/kpi-dashboard" class="sidebar-link <?php echo ($route === 'clan_leader/kpi-dashboard') ? 'active' : ''; ?>">
                <i class="fas fa-chart-line"></i>
                <span class="sidebar-link-text">KPI</span>
            </a>
            <a href="?route=clan_leader/collaborator-availability" class="sidebar-link <?php echo ($route === 'clan_leader/collaborator-availability') ? 'active' : ''; ?>">
                <i class="fas fa-calendar-alt"></i>
                <span class="sidebar-link-text">Disponibilidad</span>
            </a>
            <a href="?route=clan_leader/profile" class="sidebar-link <?php echo ($route === 'clan_leader/profile') ? 'active' : ''; ?>">
                <i class="fas fa-user"></i>
                <span class="sidebar-link-text">Perfil</span>
            </a>
            
        <?php else: ?>
            <!-- Menú de Miembro de Clan -->
            <a href="?route=clan_member" class="sidebar-link <?php echo ($route === 'clan_member' || $route === 'clan_member/dashboard') ? 'active' : ''; ?>">
                <i class="fas fa-home"></i>
                <span class="sidebar-link-text">Dashboard</span>
            </a>
            <!-- Opción Tareas oculta para clan member -->
            <!-- <a href="?route=clan_member/tasks" class="sidebar-link <?php echo (strpos($route, 'clan_member/tasks') === 0 || strpos($route, 'clan_member/task-details') === 0) ? 'active' : ''; ?>">
                <i class="fas fa-tasks"></i>
                <span class="sidebar-link-text">Tareas</span>
            </a> -->
            <a href="?route=clan_member/projects" class="sidebar-link <?php echo ($route === 'clan_member/projects') ? 'active' : ''; ?>">
                <i class="fas fa-folder"></i>
                <span class="sidebar-link-text">Proyectos</span>
            </a>
            <a href="?route=clan_member/availability" class="sidebar-link <?php echo ($route === 'clan_member/availability') ? 'active' : ''; ?>">
                <i class="fas fa-user-clock"></i>
                <span class="sidebar-link-text">Agenda</span>
            </a>
            <a href="?route=clan_member/profile" class="sidebar-link <?php echo ($route === 'clan_member/profile') ? 'active' : ''; ?>">
                <i class="fas fa-user"></i>
                <span class="sidebar-link-text">Perfil</span>
            </a>
        <?php endif; ?>
    </nav>

    <!-- Footer del Sidebar -->
    <div class="sidebar-footer">
        <div class="sidebar-user">
            <div class="sidebar-avatar">
                <?php if (!empty($avatar)): ?>
                    <img src="<?php echo Utils::asset($avatar); ?>" alt="Avatar">
                <?php else: ?>
                    <span class="sidebar-avatar-initial"><?php echo $userInitial; ?></span>
                <?php endif; ?>
            </div>
            <div class="sidebar-user-info">
                <div class="sidebar-user-name"><?php echo htmlspecialchars($userName); ?></div>
                <div class="sidebar-user-role"><?php echo htmlspecialchars($userRoleDisplay); ?></div>
            </div>
        </div>
        <a href="?route=logout" class="sidebar-link sidebar-link-logout">
            <i class="fas fa-sign-out-alt"></i>
            <span class="sidebar-link-text">Cerrar Sesión</span>
        </a>
    </div>
</aside>

<!-- Overlay para móvil -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>

<!-- Botón Hamburguesa flotante -->
<button class="hamburger-btn" id="hamburgerBtn" aria-label="Abrir menú">
    <i class="fas fa-bars"></i>
</button>

