<?php
// NO usar layout - renderizar HTML completo
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Proyectos - Polaris</title>
    
    <!-- Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo Utils::asset('polaris/apple-touch-icon.png'); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo Utils::asset('polaris/favicon-32x32.png'); ?>">
    <link rel="shortcut icon" href="<?php echo Utils::asset('polaris/favicon.ico'); ?>">
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo Utils::asset('assets/css/sidebar.css'); ?>?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="<?php echo Utils::asset('assets/css/monday-theme.css'); ?>?v=<?php echo time(); ?>">
    
    <style>
    /* ========== ESTILOS PARA VISTA DE LISTA ========== */

    /* Tabla minimalista */
    .projects-table-minimal {
        background: white;
        border-radius: 16px;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
        overflow: visible;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .table-header-minimal {
        display: grid;
        grid-template-columns: 2fr 1fr 1fr 1fr 1.2fr;
        gap: 16px;
        padding: 16px 20px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .header-cell {
        display: flex;
        align-items: center;
    }

    .table-row-minimal {
        display: grid;
        grid-template-columns: 2fr 1fr 1fr 1fr 1.2fr;
        gap: 16px;
        padding: 16px 20px;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.2s ease;
        align-items: center;
        overflow: visible !important;
        position: relative;
    }

    .table-row-minimal:hover {
        background: linear-gradient(90deg, rgba(102, 126, 234, 0.02) 0%, rgba(118, 75, 162, 0.02) 100%);
    }

    .table-row-minimal:last-child {
        border-bottom: none;
    }

    /* Celda de proyecto */
    .cell-project {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .project-icon-list {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 16px;
        flex-shrink: 0;
    }

    .project-info-list {
        flex: 1;
        min-width: 0;
    }

    .project-name-list {
        font-size: 15px;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 4px;
        line-height: 1.3;
    }

    .project-description-list {
        font-size: 12px;
        color: #7f8c8d;
        line-height: 1.3;
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
        margin-bottom: 4px;
    }

    .project-kpi-list {
        font-size: 11px;
        color: #f39c12;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    /* Celda de estado */
    .cell-status {
        display: flex;
        justify-content: center;
    }

    .status-badge-list {
        padding: 4px 12px;
        border-radius: 16px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }

    .status-badge-list.status-active,
    .status-badge-list.status-open { 
        background: rgba(39, 174, 96, 0.1); 
        color: #27ae60; 
        border: 1px solid rgba(39, 174, 96, 0.2);
    }

    .status-badge-list.status-completed { 
        background: rgba(52, 152, 219, 0.1); 
        color: #3498db; 
        border: 1px solid rgba(52, 152, 219, 0.2);
    }

    .status-badge-list.status-pending { 
        background: rgba(243, 156, 18, 0.1); 
        color: #f39c12; 
        border: 1px solid rgba(243, 156, 18, 0.2);
    }

    /* Celda de progreso */
    .cell-progress {
        display: flex;
        justify-content: center;
    }

    .progress-container-list {
        display: flex;
        align-items: center;
        gap: 8px;
        width: 100%;
    }

    .progress-bar-list {
        flex: 1;
        height: 6px;
        background: #ecf0f1;
        border-radius: 3px;
        overflow: hidden;
    }

    .progress-fill-list {
        height: 100%;
        background: linear-gradient(90deg, #27ae60 0%, #2ecc71 100%);
        border-radius: 3px;
        transition: width 0.3s ease;
    }

    .progress-text-list {
        font-size: 12px;
        font-weight: 600;
        color: #2c3e50;
        min-width: 35px;
    }

    /* Celda de tareas */
    .cell-tasks {
        display: flex;
        justify-content: center;
    }

    .tasks-summary-list {
        display: flex;
        align-items: center;
        gap: 4px;
        font-size: 14px;
        font-weight: 600;
    }

    .tasks-total {
        color: #2c3e50;
    }

    .tasks-separator {
        color: #bdc3c7;
    }

    .tasks-completed {
        color: #27ae60;
    }

    /* Celda de acciones */
    .cell-actions {
        display: flex;
        justify-content: center;
        position: relative;
    }

    .actions-list {
        display: flex;
        gap: 6px;
        position: relative;
    }

    .btn-list-action {
        padding: 0 !important;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-size: 14px;
        transition: all 0.2s ease;
        text-decoration: none;
        display: inline-flex !important;
        align-items: center;
        justify-content: center;
        width: 36px !important;
        height: 36px !important;
        min-width: 36px;
        min-height: 36px;
        box-sizing: border-box;
    }

    .btn-list-action.primary {
        background: #669AE1;
        color: white;
    }

    .btn-list-action.primary:hover {
        background: #4a7bc8;
        transform: scale(1.05);
    }
    
    .btn-list-action i {
        font-size: 14px;
    }

    .external-clan-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 2px 8px;
        background: rgba(102, 126, 234, 0.1);
        border: 1px solid rgba(102, 126, 234, 0.3);
        border-radius: 12px;
        font-size: 10px;
        color: #667eea;
        font-weight: 600;
    }
    
    /* Responsive */
    @media (max-width: 1024px) {
        .table-header-minimal,
        .table-row-minimal {
            grid-template-columns: 2fr 1fr 1fr 0.8fr;
        }
        
        .cell-progress {
            display: none;
        }
    }
    
    @media (max-width: 768px) {
        .table-header-minimal,
        .table-row-minimal {
            grid-template-columns: 1fr;
            gap: 8px;
        }
        
        .header-cell {
            display: none;
        }
        
        .cell-project,
        .cell-status,
        .cell-tasks,
        .cell-actions {
            justify-content: flex-start;
        }
    }
    
    /* Estilos de Paginación */
    .pagination-container-monday {
        padding: 20px;
        border-top: 1px solid #e2e8f0;
        background: #f8fafc;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px;
    }

    .pagination-info-monday {
        font-size: 13px;
        color: #64748b;
        font-weight: 500;
    }

    .pagination-controls-monday {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .pagination-pages-monday {
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .btn-pagination-monday {
        padding: 8px 16px;
        border: 1px solid #e2e8f0;
        background: white;
        color: #374151;
        border-radius: 6px;
        cursor: pointer;
        font-size: 13px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 6px;
        transition: all 0.2s;
        text-decoration: none;
    }

    .btn-pagination-monday:hover:not(:disabled) {
        background: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .btn-pagination-monday:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .btn-page-monday {
        min-width: 36px;
        height: 36px;
        padding: 0 8px;
        border: 1px solid #e2e8f0;
        background: white;
        color: #374151;
        border-radius: 6px;
        cursor: pointer;
        font-size: 13px;
        font-weight: 500;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
    }

    .btn-page-monday:hover {
        background: #f1f5f9;
        border-color: #3b82f6;
    }

    .btn-page-monday.active {
        background: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .pagination-ellipsis {
        padding: 0 8px;
        color: #64748b;
        font-size: 13px;
    }
    
    @media (max-width: 768px) {
        .pagination-container-monday {
            flex-direction: column;
            gap: 12px;
            padding: 16px;
        }
        
        .pagination-controls-monday {
            width: 100%;
            justify-content: center;
        }
        
        .pagination-pages-monday {
            flex-wrap: wrap;
            justify-content: center;
        }
        
        .btn-pagination-monday,
        .btn-page-monday {
            font-size: 12px;
            padding: 6px 12px;
            min-width: 32px;
            height: 32px;
        }
    }
    </style>
</head>
<body>

<?php include __DIR__ . '/../components/sidebar.php'; ?>

<div class="monday-layout">
    <main class="monday-main" style="margin-left: 0; width: 100%;">
    <!-- HEADER -->
    <header class="main-header">
        <div class="header-title-row">
            <div>
                <h1 class="page-title">Mis Proyectos</h1>
                <p style="color: var(--monday-text-secondary); margin-top: 5px;">Proyectos asignados a <?php echo htmlspecialchars($user['full_name'] ?? 'ti'); ?></p>
            </div>
        </div>
        
        <!-- Búsqueda -->
        <div class="search-container-monday" style="margin-top: 20px;">
            <div class="search-input-monday">
                <i class="fas fa-search"></i>
                <input type="text" id="searchInput" value="<?php echo htmlspecialchars($search ?? ''); ?>" 
                       placeholder="Buscar proyectos..." autocomplete="off">
                <button type="button" id="clearSearch" class="btn-clear-monday" style="display: none;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    </header>

    <!-- Contenido Principal -->
    <div class="board-container">
        <?php 
        $hasProjects = isset($projects) && is_array($projects) && count($projects) > 0;
        ?>
        <?php if ($hasProjects): ?>
            
            <!-- Vista de Lista -->
            <section class="projects-list-view animate-fade-in" id="listView">
                <div class="projects-table-minimal">
                    <div class="table-header-minimal">
                        <div class="header-cell">Proyecto</div>
                        <div class="header-cell">Estado</div>
                        <div class="header-cell">Progreso</div>
                        <div class="header-cell">Tareas</div>
                        <div class="header-cell">Acciones</div>
                    </div>
                    
                    <?php foreach ($projects as $project): ?>
                    <?php $progressPct = $project['progress_percentage'] ?? 0; ?>
                    <div class="table-row-minimal">
                        <div class="cell-project">
                            <div class="project-icon-list">
                                <i class="fas fa-project-diagram"></i>
                            </div>
                            <div class="project-info-list">
                                <div class="project-name-list"><?php echo htmlspecialchars($project['project_name']); ?></div>
                                <?php if (!empty($project['description'])): ?>
                                <div class="project-description-list project-tooltip" 
                                     data-tooltip="<?php echo htmlspecialchars($project['description']); ?>"
                                     style="cursor: help;">
                                    <?php echo strlen($project['description']) > 30 ? htmlspecialchars(substr($project['description'], 0, 30)) . '...' : htmlspecialchars($project['description']); ?>
                                </div>
                                <?php endif; ?>
                                <?php if (isset($project['kpi_points']) && $project['kpi_points'] > 0): ?>
                                <div class="project-kpi-list">
                                    <i class="fas fa-star"></i>
                                    <?php echo number_format($project['kpi_points']); ?> KPI
                                </div>
                                <?php endif; ?>
                                <?php if (isset($project['clan_name']) && $project['clan_name'] !== ($clan['clan_name'] ?? '')): ?>
                                    <span class="external-clan-badge" style="margin-left: 0; margin-top: 4px;">
                                        <i class="fas fa-external-link-alt"></i> <?php echo htmlspecialchars($project['clan_name'] ?? ''); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="cell-status">
                            <span class="status-badge-list status-<?php echo $project['status']; ?>">
                                <?php echo ucfirst($project['status']); ?>
                            </span>
                        </div>
                        
                        <div class="cell-progress">
                            <div class="progress-container-list">
                                <div class="progress-bar-list">
                                    <div class="progress-fill-list" style="width: <?php echo $progressPct; ?>%"></div>
                                </div>
                                <span class="progress-text-list"><?php echo $progressPct; ?>%</span>
                            </div>
                        </div>
                        
                        <div class="cell-tasks">
                            <div class="tasks-summary-list">
                                <span class="tasks-total"><?php echo $project['total_tasks'] ?? 0; ?></span>
                                <span class="tasks-separator">/</span>
                                <span class="tasks-completed"><?php echo $project['completed_tasks'] ?? 0; ?></span>
                            </div>
                        </div>
                        
                        <div class="cell-actions">
                            <div class="actions-list">
                                <a href="?route=clan_member/project-tasks&project_id=<?php echo $project['project_id']; ?>" class="btn-list-action primary" title="Ver Tareas">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn-list-action primary" onclick="openCreateTaskModal(<?php echo $project['project_id']; ?>)" title="Agregar Tarea al Proyecto">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Paginación -->
                <?php if (isset($pagination) && $pagination['totalPages'] > 1): ?>
                <div class="pagination-container-monday">
                    <div class="pagination-info-monday">
                        Mostrando <?= (($pagination['currentPage'] - 1) * $pagination['itemsPerPage']) + 1 ?> - 
                        <?= min($pagination['currentPage'] * $pagination['itemsPerPage'], $pagination['totalProjects']) ?> 
                        de <?= $pagination['totalProjects'] ?> proyectos
                    </div>
                    <div class="pagination-controls-monday">
                        <button class="btn-pagination-monday" 
                                onclick="goToPage(<?= max(1, $pagination['currentPage'] - 1) ?>)" 
                                <?= $pagination['currentPage'] <= 1 ? 'disabled' : '' ?>>
                            <i class="fas fa-chevron-left"></i>
                            Anterior
                        </button>
                        
                        <div class="pagination-pages-monday">
                            <?php
                            $currentPage = $pagination['currentPage'];
                            $totalPages = $pagination['totalPages'];
                            $startPage = max(1, $currentPage - 2);
                            $endPage = min($totalPages, $currentPage + 2);
                            
                            if ($startPage > 1): ?>
                                <button class="btn-page-monday" onclick="goToPage(1)">1</button>
                                <?php if ($startPage > 2): ?>
                                    <span class="pagination-ellipsis">...</span>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                                <button class="btn-page-monday <?= $i === $currentPage ? 'active' : '' ?>" 
                                        onclick="goToPage(<?= $i ?>)">
                                    <?= $i ?>
                                </button>
                            <?php endfor; ?>
                            
                            <?php if ($endPage < $totalPages): ?>
                                <?php if ($endPage < $totalPages - 1): ?>
                                    <span class="pagination-ellipsis">...</span>
                                <?php endif; ?>
                                <button class="btn-page-monday" onclick="goToPage(<?= $totalPages ?>)"><?= $totalPages ?></button>
                            <?php endif; ?>
                        </div>
                        
                        <button class="btn-pagination-monday" 
                                onclick="goToPage(<?= min($pagination['totalPages'], $pagination['currentPage'] + 1) ?>)" 
                                <?= $pagination['currentPage'] >= $pagination['totalPages'] ? 'disabled' : '' ?>>
                            Siguiente
                            <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- GIF decorativo al pie de la tabla (solo si hay proyectos) -->
                <?php if ($hasProjects): ?>
                <div class="table-footer-gif" style="text-align: center; padding: 20px; background: white; border-radius: 0 0 var(--border-radius) var(--border-radius);">
                    <img src="<?php echo Utils::asset('assets/img/proyectos.gif'); ?>" 
                         alt="Proyectos" 
                         style="max-width: 200px; height: auto; opacity: 0.8;">
                </div>
                <?php endif; ?>
            </section>
            
        <?php else: ?>
            <div class="empty-state-monday" style="text-align: center; padding: 60px 20px; background: white; border-radius: var(--border-radius); box-shadow: var(--box-shadow);">
                <div style="font-size: 64px; margin-bottom: 20px;">📋</div>
                <h3 style="font-size: 1.5rem; font-weight: 600; color: var(--monday-text-color); margin-bottom: 8px;">No hay proyectos asignados</h3>
                <p style="color: var(--monday-text-secondary);">No tienes proyectos asignados en este momento.</p>
            </div>
        <?php endif; ?>
    </div>
    </main>
</div>

<!-- Modal crear tarea - Diseño Monday.com -->
<div id="createTaskModal" class="modal-overlay-task" style="display: none;">
    <div class="modal-content-task">
        <div class="modal-header-task">
            <div style="display: flex; align-items: center; gap: 12px;">
                <img src="<?php echo Utils::asset('assets/img/Task_Loader.gif'); ?>" alt="Loading" style="width: 96px; height: 96px;">
                <h3>Nueva Tarea</h3>
            </div>
            <button type="button" class="modal-close-task" onclick="closeCreateTaskModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <form id="createTaskForm" class="modal-body-task">
            <input type="hidden" id="task_project_id" name="project_id" value="" />
            
            <div class="form-group-task">
                <label for="task_name">Título de la Tarea *</label>
                <input type="text" id="task_name" name="task_name" class="form-control-task" placeholder="Escribe un título claro y conciso" required>
            </div>
            
            <div class="form-group-task">
                <label for="task_description">Descripción</label>
                <textarea id="task_description" name="description" class="form-control-task" rows="3" placeholder="Contexto, entregables y consideraciones"></textarea>
            </div>
            
            <div class="form-group-task">
                <label for="task_priority">Prioridad</label>
                <select id="task_priority" name="priority" class="form-control-task">
                    <option value="low">Baja</option>
                    <option value="medium" selected>Media</option>
                    <option value="high">Alta</option>
                    <option value="urgent">Urgente</option>
                </select>
            </div>
            
            <div class="form-group-task" id="dueDateGroupMember">
                <label for="task_due_date">Fecha Límite</label>
                <input type="date" id="task_due_date" name="due_date" class="form-control-task">
            </div>
            
            <!-- Campos de Recurrencia -->
            <div class="form-group-task">
                <label class="checkbox-label-modern-task">
                    <input type="checkbox" id="isRecurrentMember" name="is_recurrent" onchange="toggleRecurrenceFieldsMember()">
                    <span class="checkbox-text">Tarea Recurrente</span>
                </label>
                <small class="field-help-task">Marca si esta tarea debe repetirse automáticamente</small>
            </div>
            
            <div id="recurrenceFieldsMember" class="recurrence-fields-task" style="display: none;">
                <div class="form-group-task">
                    <label for="recurrence_type">Tipo de Recurrencia</label>
                    <select id="recurrenceTypeMember" name="recurrence_type" class="form-control-task">
                        <option value="">Seleccionar...</option>
                        <option value="daily">Diaria</option>
                        <option value="weekly">Semanal</option>
                        <option value="monthly">Mensual</option>
                    </select>
                </div>
                
                <div class="form-group-task">
                    <label for="recurrence_start">Fecha de Inicio</label>
                    <input type="date" id="recurrenceStartMember" name="recurrence_start_date" class="form-control-task">
                    <small class="field-help-task">Primera fecha en que se ejecutará la tarea</small>
                </div>
                
                <div class="form-group-task">
                    <label for="recurrence_end">Fecha de Vigencia</label>
                    <input type="date" id="recurrenceEndMember" name="recurrence_end_date" class="form-control-task">
                    <small class="field-help-task">Hasta cuándo se generarán las repeticiones (opcional)</small>
                </div>
            </div>
            
            <div id="createTaskErrors" class="form-errors-task" style="display:none; margin-top: 16px; padding: 12px; background: rgba(239, 68, 68, 0.1); border-left: 4px solid #ef4444; border-radius: 8px; color: #dc2626;"></div>
        </form>
        
        <div class="modal-footer-task">
            <button type="button" class="btn-secondary-task" onclick="closeCreateTaskModal()">
                <i class="fas fa-times"></i>
                Cancelar
            </button>
            <button type="button" id="createTaskSubmitBtn" class="btn-primary-task" onclick="submitCreateTaskForm()">
                <i class="fas fa-plus"></i>
                Crear Tarea
            </button>
        </div>
    </div>
</div>

<style>
/* ========== ESTILOS MODAL MONDAY.COM ========== */
@keyframes fadeInTask {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes scaleInTask {
    from { 
        opacity: 0;
        transform: scale(0.95) translateY(10px);
    }
    to { 
        opacity: 1;
        transform: scale(1) translateY(0);
    }
}

.modal-overlay-task {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(15, 23, 42, 0.6);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
    animation: fadeInTask 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.modal-content-task {
    background: rgba(252, 252, 253, 0.9);
    backdrop-filter: blur(40px) saturate(105%);
    -webkit-backdrop-filter: blur(40px) saturate(105%);
    border-radius: 20px;
    width: 90%;
    max-width: 600px;
    max-height: 90vh;
    overflow: hidden;
    box-shadow: 
        0 8px 32px rgba(16, 185, 129, 0.04),
        0 0 0 1px rgba(255, 255, 255, 0.4) inset,
        0 1px 2px rgba(0, 0, 0, 0.05);
    border: 1px solid rgba(236, 253, 245, 0.08);
    animation: scaleInTask 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    display: flex;
    flex-direction: column;
}

.modal-content-task::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 100%;
    background: linear-gradient(
        135deg,
        rgba(236, 253, 245, 0.02) 0%,
        rgba(209, 250, 229, 0.01) 50%,
        rgba(252, 252, 253, 0.01) 100%
    );
    pointer-events: none;
    border-radius: 20px;
}

.modal-close-task {
    background: rgba(239, 68, 68, 0.1);
    border: none;
    border-radius: 10px;
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    color: #dc2626;
    font-size: 18px;
    flex-shrink: 0;
}

.modal-close-task:hover {
    background: rgba(239, 68, 68, 0.2);
    transform: scale(1.05);
}

.modal-header-task {
    padding: 24px 28px;
    border-bottom: 1px solid rgba(236, 253, 245, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: linear-gradient(to bottom, rgba(252, 252, 253, 0.6), rgba(236, 253, 245, 0.08));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
    flex-shrink: 0;
}

.modal-header-task > div {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
    min-width: 0;
}

.modal-header-task > div img {
    flex-shrink: 0;
}

.modal-header-task h3 {
    flex: 1;
    min-width: 0;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    margin: 0;
    font-size: 1.3rem;
    font-weight: 600;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    letter-spacing: -0.02em;
}

.modal-body-task {
    padding: 28px;
    overflow-y: auto;
    position: relative;
    z-index: 1;
    background: rgba(252, 252, 253, 0.4);
    flex: 1;
    min-height: 0;
}

.form-group-task {
    margin-bottom: 20px;
}

.form-group-task label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: #334155;
    font-size: 0.9rem;
}

.form-control-task {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid rgba(203, 213, 225, 0.5);
    border-radius: 10px;
    font-size: 0.95rem;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    background: rgba(255, 255, 255, 0.8);
    color: #1e293b;
}

.form-control-task:focus {
    outline: none;
    border-color: #10b981;
    box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
    background: white;
}

.form-control-task::placeholder {
    color: #94a3b8;
}

.checkbox-label-modern-task {
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    user-select: none;
}

.checkbox-label-modern-task input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
}

.field-help-task {
    display: block;
    margin-top: 6px;
    font-size: 0.8rem;
    color: #64748b;
}

.modal-footer-task {
    padding: 20px 28px 24px;
    border-top: 1px solid rgba(236, 253, 245, 0.1);
    display: flex;
    gap: 12px;
    justify-content: flex-end;
    background: linear-gradient(to top, rgba(252, 252, 253, 0.6), rgba(236, 253, 245, 0.08));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
    flex-shrink: 0;
}

.btn-secondary-task {
    padding: 12px 24px;
    background: rgba(148, 163, 184, 0.1);
    border: 2px solid rgba(148, 163, 184, 0.2);
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #475569;
    font-size: 0.9rem;
}

.btn-secondary-task:hover {
    background: rgba(148, 163, 184, 0.15);
    transform: translateY(-1px);
}

.btn-primary-task {
    padding: 12px 24px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border: none;
    border-radius: 10px;
    color: white;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    display: inline-flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.2);
    font-size: 0.9rem;
}

.btn-primary-task:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.3);
}

.btn-primary-task:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.modal-body-task::-webkit-scrollbar {
    width: 8px;
}

.modal-body-task::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.05);
    border-radius: 10px;
}

.modal-body-task::-webkit-scrollbar-thumb {
    background: rgba(148, 163, 184, 0.3);
    border-radius: 10px;
}

.modal-body-task::-webkit-scrollbar-thumb:hover {
    background: rgba(148, 163, 184, 0.5);
}

/* Responsive para el modal */
@media (max-width: 768px) {
    .modal-content-task {
        width: 95%;
        max-width: 95%;
        max-height: 95vh;
        margin: 10px;
    }
    
    .modal-header-task {
        padding: 16px 20px;
    }
    
    .modal-header-task > div img {
        width: 48px !important;
        height: 48px !important;
    }
    
    .modal-header-task h3 {
        font-size: 1.1rem;
    }
    
    .modal-body-task {
        padding: 20px;
    }
    
    .modal-footer-task {
        padding: 16px 20px;
        flex-wrap: wrap;
    }
    
    .btn-primary-task, .btn-secondary-task {
        padding: 10px 20px;
        font-size: 0.85rem;
        flex: 1;
        min-width: 120px;
    }
}
</style>

<!-- Scripts -->
<script src="<?php echo Utils::asset('assets/js/sidebar.js'); ?>?v=<?php echo time(); ?>"></script>

<script>
// Función para ir a una página específica
function goToPage(page) {
    const url = new URL(window.location);
    url.searchParams.set('page', page);
    const search = document.getElementById('searchInput').value;
    if (search) {
        url.searchParams.set('search', search);
    }
    window.location.href = url.toString();
}

// Búsqueda en tiempo real mejorada
(function() {
    const searchInput = document.getElementById('searchInput');
    const clearSearchBtn = document.getElementById('clearSearch');
    let searchTimeout;
    
    if (searchInput && clearSearchBtn) {
        // Mostrar botón limpiar si hay valor inicial
        if (searchInput.value.trim()) {
            clearSearchBtn.style.display = 'block';
        }
        
        searchInput.addEventListener('input', function() {
            const searchValue = this.value.trim();
            clearSearchBtn.style.display = searchValue ? 'block' : 'none';
            
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                const url = new URL(window.location);
                
                if (searchValue) {
                    url.searchParams.set('search', searchValue);
                    url.searchParams.delete('page'); // Resetear a página 1 al buscar
                } else {
                    url.searchParams.delete('search');
                    url.searchParams.delete('page');
                }
                
                window.location.href = url.toString();
            }, 500);
        });
        
        clearSearchBtn.addEventListener('click', function() {
            searchInput.value = '';
            clearSearchBtn.style.display = 'none';
            
            const url = new URL(window.location);
            url.searchParams.delete('search');
            url.searchParams.delete('page');
            window.location.href = url.toString();
        });
    }
})();

// Funciones del modal Monday.com
function openCreateTaskModal(projectId) {
    const modal = document.getElementById('createTaskModal');
    const projectIdInput = document.getElementById('task_project_id');
    const dueDateField = document.getElementById('task_due_date');
    
    if (modal && projectIdInput) {
        projectIdInput.value = projectId;
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
        
        // Establecer fecha mínima como hoy
        if (dueDateField) {
            dueDateField.min = new Date().toISOString().split('T')[0];
        }
    }
}

function closeCreateTaskModal() {
    const modal = document.getElementById('createTaskModal');
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
        // Limpiar formulario
        const form = document.getElementById('createTaskForm');
        if (form) form.reset();
        // Resetear campos de recurrencia
        const recurrenceFields = document.getElementById('recurrenceFieldsMember');
        if (recurrenceFields) recurrenceFields.style.display = 'none';
        const dueDateGroup = document.getElementById('dueDateGroupMember');
        if (dueDateGroup) dueDateGroup.style.display = 'block';
        // Limpiar errores
        const errorBox = document.getElementById('createTaskErrors');
        if (errorBox) errorBox.style.display = 'none';
    }
}

// Función para mostrar/ocultar campos de recurrencia
function toggleRecurrenceFieldsMember() {
    const checkbox = document.getElementById('isRecurrentMember');
    const fields = document.getElementById('recurrenceFieldsMember');
    const dueDateField = document.getElementById('task_due_date');
    const dueDateGroup = document.getElementById('dueDateGroupMember');
    
    if (checkbox.checked) {
        fields.style.display = 'block';
        if (dueDateGroup) dueDateGroup.style.display = 'none';
        if (dueDateField) {
            dueDateField.required = false;
            dueDateField.value = '';
        }
        document.getElementById('recurrenceTypeMember').required = true;
        document.getElementById('recurrenceStartMember').required = true;
    } else {
        fields.style.display = 'none';
        if (dueDateGroup) dueDateGroup.style.display = 'block';
        if (dueDateField) dueDateField.required = false;
        document.getElementById('recurrenceTypeMember').required = false;
        document.getElementById('recurrenceStartMember').required = false;
        document.getElementById('recurrenceTypeMember').value = '';
        document.getElementById('recurrenceStartMember').value = '';
        document.getElementById('recurrenceEndMember').value = '';
    }
}

function submitCreateTaskForm() {
    const form = document.getElementById('createTaskForm');
    const title = form.querySelector('input[name="task_name"]').value.trim();
    const errorBox = document.getElementById('createTaskErrors');
    const submitBtn = document.getElementById('createTaskSubmitBtn');
    
    if (!title) {
        errorBox.style.display = 'block';
        errorBox.textContent = 'El título es requerido.';
        return;
    }
    
    errorBox.style.display = 'none';
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Creando...';
    
    const fd = new FormData(form);
    const projectId = form.querySelector('input[name="project_id"]').value;
    
    fetch('?route=clan_member/create-project-task', { 
        method: 'POST', 
        body: fd, 
        credentials: 'same-origin' 
    })
    .then(async r => { 
        const t = await r.text(); 
        try { 
            return JSON.parse(t); 
        } catch(e) { 
            console.error(t); 
            return {success: false, message: 'Respuesta inválida'}; 
        } 
    })
    .then(d => { 
        if (!d.success) { 
            errorBox.style.display = 'block'; 
            errorBox.textContent = d.message || 'Error al crear la tarea'; 
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-plus"></i> Crear Tarea';
            return; 
        }
        
        // Redirigir después de crear exitosamente
        setTimeout(() => {
            window.location.href = '?route=clan_member/project-tasks&project_id=' + projectId;
        }, 500);
    })
    .catch(() => { 
        errorBox.style.display = 'block'; 
        errorBox.textContent = 'Error de red'; 
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-plus"></i> Crear Tarea';
    });
}

// Cerrar modal con ESC
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeCreateTaskModal();
    }
});

// Cerrar modal al hacer clic fuera
document.getElementById('createTaskModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closeCreateTaskModal();
    }
});
</script>

</body>
</html>
