# RinoTrack - Despliegue Automático

## 🚀 Configuración Completada

El proyecto RinoTrack ha sido configurado para despliegue automático al servidor remoto.

### 📋 Información del Servidor

- **Servidor**: `bitnami@52.3.160.124`
- **Directorio**: `/home/bitnami/htdocs/rinotrackalfa`
- **URL**: http://52.3.160.124/rinotrackalfa/public/
- **Archivo PEM**: `rinotrack.pem` (en la raíz del proyecto)

## 🛠️ Scripts de Despliegue

### 1. Despliegue Completo (`deploy.sh`)

Configuración inicial completa del servidor:

```bash
./deploy.sh
```

**Qué hace:**
- ✅ Verifica conexión SSH
- ✅ Crea directorios necesarios
- ✅ Sincroniza todos los archivos
- ✅ Configura permisos correctos
- ✅ Actualiza configuración para producción
- ✅ Configura .htaccess
- ✅ Verifica la instalación

### 2. Despliegue Rápido (`auto-deploy.sh`)

Sincronización rápida de cambios:

```bash
./auto-deploy.sh
```

**Qué hace:**
- ⚡ Sincroniza solo archivos modificados
- ⚡ Despliegue rápido y eficiente
- ⚡ Ideal para desarrollo continuo

### 3. Monitoreo Automático (`watch-and-deploy.sh`)

Despliegue automático al detectar cambios:

```bash
# Instalar fswatch (solo la primera vez)
brew install fswatch

# Iniciar monitoreo automático
./watch-and-deploy.sh
```

**Qué hace:**
- 👀 Monitorea cambios en tiempo real
- 🚀 Despliega automáticamente cuando detecta modificaciones
- 🔄 Funciona continuamente hasta que se detenga (Ctrl+C)

## 🎨 Estilo Visual Mantenido

El sistema mantiene **exactamente** el mismo estilo visual del tablero kanban:

### ✅ Características Preservadas

- **4 columnas**: Vencidas, Hoy, Esta Semana, Futuras
- **Gradientes de colores** en headers de columnas
- **Cards con bordes de colores** según la columna
- **Efectos hover** y animaciones suaves
- **Subtareas con fondo pastel** y icono 📋
- **Tabs minimalistas** (Mis Tareas / Equipo)
- **Responsive design** mantenido

### 🎯 Colores por Tipo de Proyecto

- **Personal**: Morado (`#8b5cf6`)
- **Recurrente**: Cian (`#06b6d4`)
- **Eventual**: Naranja (`#f97316`)
- **Normal**: Verde (`#10b981`)

## 🔧 Configuración Automática

### URLs Dinámicas

El sistema detecta automáticamente la URL base:
- ✅ Funciona en `/rinotrack/public/`
- ✅ Funciona en `/rinotrackalfa/public/`
- ✅ Funciona en cualquier directorio

### Rutas Corregidas

- ✅ `.htaccess` configurado para múltiples directorios
- ✅ Detección automática de protocolo (HTTP/HTTPS)
- ✅ Manejo correcto de assets y uploads

## 📝 Flujo de Trabajo Recomendado

### Para Desarrollo Continuo

1. **Iniciar monitoreo automático:**
   ```bash
   ./watch-and-deploy.sh
   ```

2. **Hacer cambios en el código**
   - Los cambios se detectan automáticamente
   - Se despliegan al servidor en segundos

3. **Verificar en el navegador:**
   - http://52.3.160.124/rinotrackalfa/public/

### Para Despliegues Manuales

```bash
# Cambios rápidos
./auto-deploy.sh

# Configuración completa (si hay problemas)
./deploy.sh
```

## 🔍 Verificación y Troubleshooting

### Verificar Estado del Servidor

```bash
ssh -i rinotrack.pem bitnami@52.3.160.124 "cd /home/bitnami/htdocs/rinotrackalfa && ls -la"
```

### Ver Logs de Errores

```bash
ssh -i rinotrack.pem bitnami@52.3.160.124 "tail -f /tmp/rinotrack_errors.log"
```

### Verificar Permisos

```bash
ssh -i rinotrack.pem bitnami@52.3.160.124 "ls -la /home/bitnami/htdocs/rinotrackalfa/public/uploads/"
```

## 📁 Archivos Importantes

- `rinotrack.pem` - Clave SSH (no se despliega)
- `deploy.sh` - Script de despliegue completo
- `auto-deploy.sh` - Script de despliegue rápido
- `watch-and-deploy.sh` - Monitoreo automático
- `.htaccess` - Configuración de rutas
- `config/app.php` - Configuración con URLs dinámicas
- `KANBAN_STYLE_GUIDE.md` - Guía de estilos del kanban

## 🎉 ¡Listo para Usar!

El sistema está completamente configurado y listo para desarrollo continuo con despliegue automático. El estilo visual del kanban se mantiene exactamente igual al diseño original.

### 🌐 URL de Acceso

**Aplicación desplegada**: http://52.3.160.124/rinotrackalfa/public/

---

*Configurado por el asistente AI para mantener el estilo visual exacto del tablero kanban y habilitar despliegue automático.*
