# 📁 Configuración de Permisos para Uploads

## 🎯 Problema

PHP-FPM necesita permisos para **crear, modificar y eliminar** archivos en la carpeta `public/uploads/`.

## 🔍 Análisis del Sistema

### Usuario que ejecuta PHP-FPM
```bash
$ ps aux | grep php-fpm
daemon    863849  php-fpm: pool www
daemon    864241  php-fpm: pool www
daemon    864242  php-fpm: pool www
```
**PHP-FPM corre como usuario `daemon`**

### Problema Común
Si la carpeta `uploads/` tiene permisos `755` y pertenece a `bitnami:bitnami`:
- ✅ PHP puede **leer** archivos
- ❌ PHP **NO puede crear** archivos
- ❌ PHP **NO puede modificar** archivos
- ❌ PHP **NO puede eliminar** archivos

## ✅ Solución Correcta

### Configuración de Permisos

| Elemento | Propietario | Grupo | Permisos | Explicación |
|----------|-------------|-------|----------|-------------|
| `uploads/` (dir) | `bitnami` | `daemon` | `775` (rwxrwxr-x) | Ambos usuarios pueden crear/eliminar archivos |
| `task_attachments/` (dir) | `bitnami` | `daemon` | `775` (rwxrwxr-x) | Ambos usuarios pueden crear/eliminar archivos |
| Archivos | `bitnami` | `daemon` | `664` (rw-rw-r--) | Ambos usuarios pueden leer/escribir |

### Comandos para Aplicar

#### Desarrollo
```bash
ssh bitnami@52.3.160.124
cd /home/bitnami/htdocs/desarrollo/rinotrack

# Cambiar propietario y grupo
sudo chown -R bitnami:daemon public/uploads

# Directorios: 775
sudo chmod 775 public/uploads
sudo find public/uploads -type d -exec chmod 775 {} \;

# Archivos: 664
sudo find public/uploads -type f -exec chmod 664 {} \;
```

#### Producción
```bash
ssh bitnami@52.3.160.124
cd /home/bitnami/htdocs/rinotrackalfa

# Cambiar propietario y grupo
sudo chown -R bitnami:daemon public/uploads

# Directorios: 775
sudo chmod 775 public/uploads
sudo find public/uploads -type d -exec chmod 775 {} \;

# Archivos: 664
sudo find public/uploads -type f -exec chmod 664 {} \;
```

## 🚀 Script Automático

Hemos creado un script para aplicar los permisos automáticamente:

### Uso del Script

```bash
# Para desarrollo
./fix-uploads-permissions.sh desarrollo

# Para producción
./fix-uploads-permissions.sh produccion
```

### Características del Script
- ✅ Verifica el usuario de PHP-FPM
- ✅ Muestra permisos antes y después
- ✅ Aplica permisos recursivamente
- ✅ Crea directorios si no existen

## 🔐 Explicación de Permisos

### Permisos Unix (Octales)

| Permiso | Octal | Binario | Significado |
|---------|-------|---------|-------------|
| `rwx` | 7 | 111 | Lectura + Escritura + Ejecución |
| `rw-` | 6 | 110 | Lectura + Escritura |
| `r-x` | 5 | 101 | Lectura + Ejecución |
| `r--` | 4 | 100 | Solo lectura |

### Permisos 775 (Directorios)
```
rwx rwx r-x
│   │   └─ Otros: Lectura + Ejecución
│   └───── Grupo (daemon): Lectura + Escritura + Ejecución
└───────── Propietario (bitnami): Lectura + Escritura + Ejecución
```
**Resultado:** `bitnami` y `daemon` pueden crear/eliminar archivos

### Permisos 664 (Archivos)
```
rw- rw- r--
│   │   └─ Otros: Solo lectura
│   └───── Grupo (daemon): Lectura + Escritura
└───────── Propietario (bitnami): Lectura + Escritura
```
**Resultado:** `bitnami` y `daemon` pueden modificar archivos

## 🧪 Verificación

### Verificar Permisos Actuales
```bash
# Ver permisos de uploads/
ls -la /home/bitnami/htdocs/desarrollo/rinotrack/public/uploads/

# Ver permisos de task_attachments/
ls -la /home/bitnami/htdocs/desarrollo/rinotrack/public/uploads/task_attachments/
```

### Permisos Correctos (Ejemplo)
```
drwxrwxr-x 3 bitnami daemon    12288 uploads/
drwxrwxr-x 2 bitnami daemon    20480 task_attachments/
-rw-rw-r-- 1 bitnami daemon   314399 avatar_10_1758122603.jpeg
-rw-rw-r-- 1 bitnami daemon   885869 avatar_13_1756843672.png
```

### Prueba de Funcionamiento
1. **Subir un archivo** desde la aplicación
2. **Verificar** que se creó correctamente
3. **Modificar** el archivo si es necesario
4. **Eliminar** el archivo si es necesario

## 📋 Checklist de Permisos

- [x] PHP-FPM corre como `daemon`
- [x] Carpeta `uploads/` es `bitnami:daemon` con `775`
- [x] Carpeta `task_attachments/` es `bitnami:daemon` con `775`
- [x] Archivos son `bitnami:daemon` con `664`
- [x] Script de despliegue aplica permisos automáticamente
- [x] Script manual disponible para correcciones

## 🔄 Integración con Despliegue

### deploy-desarrollo.sh
El script de despliegue ya incluye la configuración automática de permisos:

```bash
# Permisos especiales para uploads - usar grupo daemon para PHP-FPM
mkdir -p public/uploads/task_attachments

# Cambiar propietario y grupo (bitnami:daemon)
sudo chown -R bitnami:daemon public/uploads

# Directorios: 775 (rwxrwxr-x) para que daemon pueda crear archivos
sudo chmod -R 775 public/uploads

# Archivos: 664 (rw-rw-r--) para que daemon pueda escribir
sudo find public/uploads -type f -exec chmod 664 {} \;
```

## ❓ Troubleshooting

### Error: "Permission denied" al subir archivo

**Causa:** Permisos incorrectos en `uploads/`

**Solución:**
```bash
./fix-uploads-permissions.sh desarrollo
```

### Error: "Failed to write file"

**Causa:** Grupo incorrecto (debería ser `daemon`)

**Solución:**
```bash
ssh bitnami@52.3.160.124
cd /home/bitnami/htdocs/desarrollo/rinotrack
sudo chown -R bitnami:daemon public/uploads
sudo chmod -R 775 public/uploads
sudo find public/uploads -type f -exec chmod 664 {} \;
```

### Los archivos nuevos tienen permisos incorrectos

**Causa:** PHP crea archivos con `umask` que no respeta el grupo

**Solución:** Los permisos actuales (`775` directorios, `664` archivos con grupo `daemon`) son suficientes. PHP podrá escribir independientemente del `umask`.

## 📚 Referencias

- **Usuario PHP-FPM:** `daemon`
- **Grupo correcto:** `daemon`
- **Directorios:** `775` (rwxrwxr-x)
- **Archivos:** `664` (rw-rw-r--)
- **Propietario:** `bitnami:daemon`

---

**Última actualización:** 21 de noviembre de 2025  
**Estado:** ✅ Configuración aplicada y verificada

