# Cambios para Soporte de Múltiples Clanes

## Fecha: 2025-11-21

## Resumen
Se ha implementado un sistema completo para que los usuarios puedan pertenecer a múltiples clanes simultáneamente y cambiar entre ellos.

## Cambios en la Base de Datos

### Nueva tabla: `User_Active_Clan`
```sql
CREATE TABLE IF NOT EXISTS User_Active_Clan (
    user_id INT NOT NULL,
    active_clan_id INT NOT NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (user_id),
    FOREIGN KEY (user_id) REFERENCES Users(user_id) ON DELETE CASCADE,
    FOREIGN KEY (active_clan_id) REFERENCES Clans(clan_id) ON DELETE CASCADE
)
```

### Nuevos índices
- `idx_clan_members_user` en `Clan_Members(user_id)`
- `idx_clan_members_clan` en `Clan_Members(clan_id)`

### Nueva vista: `User_Clans_View`
Proporciona una vista agregada de usuarios con sus clanes y clan activo.

## Archivos Modificados

### 1. Modelos

#### `app/models/User.php`
- **Modificado**: `getUserClan()` - Ahora retorna el clan activo del usuario
- **Nuevo**: `getUserClans()` - Obtiene todos los clanes del usuario
- **Nuevo**: `getActiveClan()` - Obtiene el clan activo del usuario
- **Nuevo**: `setActiveClan()` - Establece el clan activo del usuario

#### `app/models/Auth.php`
- **Modificado**: `createSession()` - Ahora carga todos los clanes y establece el clan activo en sesión
- **Modificado**: `clearSession()` - Limpia información de clanes de la sesión
- **Nuevo**: `switchActiveClan()` - Cambia el clan activo del usuario
- **Nuevo**: `getActiveClanId()` - Obtiene ID del clan activo en sesión
- **Nuevo**: `getUserClans()` - Obtiene clanes del usuario en sesión

### 2. Controladores

#### `app/controllers/DashboardController.php`
- **Nuevo**: `switchClan()` - Método para cambiar el clan activo vía AJAX

### 3. Vistas

#### `app/views/components/sidebar.php`
- **Nuevo**: Selector de clanes (solo se muestra si el usuario tiene más de un clan)
- El selector aparece justo debajo del header del sidebar
- Se oculta automáticamente cuando el sidebar está colapsado

### 4. Estilos

#### `public/assets/css/sidebar.css`
- **Nuevos estilos**: `.clan-selector` y componentes relacionados
- Diseño consistente con el resto de la interfaz
- Animaciones suaves para cambio de clan
- Soporte responsivo

### 5. JavaScript

#### `public/assets/js/sidebar.js`
- **Nueva función**: `initClanSelector()` - Maneja el cambio de clan
- Realiza llamada AJAX al cambiar de clan
- Recarga la página automáticamente después de cambiar
- Manejo de errores y estados de loading

## Archivos Nuevos

### Scripts de Migración

1. **`migration_multi_clan.sql`**
   - Script SQL para crear la estructura de base de datos
   - Puede ejecutarse directamente en MySQL

2. **`public/run_migration.php`**
   - Script PHP para ejecutar la migración desde el navegador
   - URL: `http://tu-servidor/run_migration.php`
   - Proporciona feedback visual del proceso

3. **`public/create_polaris_clan.php`**
   - Script para crear el clan POLARIS y asignar miembros
   - URL: `http://tu-servidor/create_polaris_clan.php?allow=1`
   - Asigna automáticamente 10 miembros al clan

## Funcionalidades Implementadas

### 1. Gestión de Múltiples Clanes
- Los usuarios pueden pertenecer a múltiples clanes simultáneamente
- La tabla `Clan_Members` ya soportaba esto (relación muchos a muchos)
- Ahora se aprovecha completamente esta capacidad

### 2. Clan Activo
- Cada usuario tiene un "clan activo" que se usa para filtrar proyectos, tareas, etc.
- El clan activo se almacena en:
  - Base de datos: tabla `User_Active_Clan`
  - Sesión: variable `$_SESSION['active_clan_id']`

### 3. Selector de Clan
- Aparece en el sidebar para usuarios con múltiples clanes
- Dropdown elegante con todos los clanes del usuario
- Cambio instantáneo mediante AJAX
- Recarga automática de la página para reflejar el cambio

### 4. Compatibilidad Retroactiva
- Todo el código existente sigue funcionando
- `getUserClan()` ahora retorna el clan activo, manteniendo compatibilidad
- Los usuarios con un solo clan no ven cambios en la interfaz

## Flujo de Cambio de Clan

1. Usuario selecciona un clan del dropdown
2. JavaScript detecta el cambio y muestra estado de loading
3. Se envía petición POST a `?route=dashboard/switch-clan`
4. El controlador valida que el usuario pertenece al clan
5. Se actualiza la base de datos y la sesión
6. JavaScript recarga la página automáticamente
7. El usuario ve su dashboard filtrado por el nuevo clan activo

## Instrucciones de Despliegue

### Opción 1: Ejecución Automática (Recomendada)
```bash
./deploy.sh
```

### Opción 2: Manual

1. **Subir archivos al servidor**
   ```bash
   rsync -avz --exclude='.git' -e "ssh -i rinotrack.pem" \
     ./ bitnami@52.3.160.124:/home/bitnami/htdocs/alfa/
   ```

2. **Ejecutar migración** (una sola vez)
   - Navegar a: `http://52.3.160.124/run_migration.php`
   - O ejecutar: `mysql -u usuario -p base_datos < migration_multi_clan.sql`

3. **Crear clan POLARIS** (una sola vez)
   - Navegar a: `http://52.3.160.124/create_polaris_clan.php?allow=1`
   - O usar la interfaz de admin para crear el clan y asignar miembros

## Verificación Post-Despliegue

1. **Verificar migración**
   ```sql
   SELECT COUNT(*) FROM User_Active_Clan;
   -- Debe retornar el número de usuarios activos
   ```

2. **Verificar usuarios con múltiples clanes**
   ```sql
   SELECT u.full_name, COUNT(cm.clan_id) as total_clans
   FROM Users u
   JOIN Clan_Members cm ON u.user_id = cm.user_id
   GROUP BY u.user_id
   HAVING COUNT(cm.clan_id) > 1;
   ```

3. **Probar selector de clan**
   - Login con un usuario que tenga múltiples clanes
   - Verificar que aparece el selector en el sidebar
   - Cambiar de clan y verificar que la página se recarga
   - Verificar que los proyectos/tareas se filtran por el nuevo clan

## Notas Importantes

1. **Rendimiento**: Los índices agregados mejoran el rendimiento de las consultas
2. **Sesión**: El clan activo se almacena en sesión para evitar consultas repetitivas
3. **Seguridad**: El cambio de clan valida que el usuario pertenezca al clan objetivo
4. **UX**: El selector solo aparece si el usuario tiene más de un clan
5. **Responsive**: El selector se oculta cuando el sidebar está colapsado

## Mejoras Futuras Sugeridas

1. Agregar un indicador visual de "cambio de clan" más prominente
2. Mostrar notificación toast al cambiar de clan exitosamente
3. Agregar opción de "clan favorito" o "clan por defecto"
4. Implementar permisos diferenciados por clan
5. Agregar historial de cambios de clan para auditoría

## Soporte

Para cualquier problema o pregunta, contactar al equipo de desarrollo.

---
Última actualización: 2025-11-21

