# Guía de Estilos del Kanban - RinoTrack

## Resumen del Despliegue Completado

✅ **Despliegue Automático Configurado**
- Servidor: `bitnami@52.3.160.124`
- Directorio: `/home/bitnami/htdocs/rinotrackalfa`
- URL: `http://52.3.160.124/rinotrackalfa/public/`
- Scripts: `deploy.sh` y `auto-deploy.sh` creados

✅ **Configuraciones Actualizadas**
- APP_URL con detección automática de directorio
- .htaccess configurado para múltiples directorios
- Rutas corregidas para funcionar en `/rinotrackalfa/`

## Estilos del Kanban Mantenidos

### 1. Estructura del Tablero Kanban

```css
.kanban-board {
    display: grid;
    grid-template-columns: 1fr 1fr 1fr 1fr; /* 4 columnas iguales */
    gap: 20px;
    margin: 0;
    padding: 0;
    width: 100%;
    max-width: none;
    background: transparent;
}
```

### 2. Columnas del Kanban

```css
.kanban-column {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    border: 1px solid rgba(255, 255, 255, 0.2);
}
```

### 3. Headers de Columnas con Gradientes

- **Vencidas**: `linear-gradient(135deg, #ef4444, #dc2626)` - Rojo
- **Hoy**: `linear-gradient(135deg, #f59e0b, #d97706)` - Naranja
- **Esta Semana**: `linear-gradient(135deg, #3b82f6, #2563eb)` - Azul
- **Futuras**: `linear-gradient(135deg, #10b981, #059669)` - Verde

### 4. Cards de Tareas

```css
.task-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 8px 10px;
    margin-bottom: 6px;
    transition: all 0.2s ease;
    cursor: pointer;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    display: flex;
    flex-direction: column;
    gap: 4px;
    min-height: 50px;
}

.task-card:hover {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
    transform: translateY(-1px);
}
```

### 5. Bordes de Color por Columna

- **Vencidas**: `border-left: 4px solid #ef4444`
- **Hoy**: `border-left: 4px solid #f59e0b`
- **Esta Semana**: `border-left: 4px solid #3b82f6`
- **Futuras**: `border-left: 4px solid #10b981`

### 6. Colores por Tipo de Proyecto

```css
.task-card.project-personal { border-left-color: #8b5cf6 !important; } /* Morado */
.task-card.project-recurrent { border-left-color: #06b6d4 !important; } /* Cian */
.task-card.project-eventual { border-left-color: #f97316 !important; } /* Naranja */
.task-card.project-normal { border-left-color: #10b981 !important; } /* Verde */
```

### 7. Subtareas con Fondo Pastel

```css
.subtask-card {
    background: linear-gradient(135deg, #fef7ff 0%, #f3e8ff 100%);
    border: 1px solid #e9d5ff;
    border-radius: 8px;
    padding: 8px 10px;
    margin-bottom: 6px;
    box-shadow: 0 1px 3px rgba(139, 92, 246, 0.1);
    cursor: pointer;
    transition: all 0.2s ease;
    position: relative;
    border-left: 4px solid #a855f7;
}

.subtask-card::before {
    content: "📋";
    position: absolute;
    top: 8px;
    right: 8px;
    font-size: 12px;
    opacity: 0.7;
}
```

### 8. Tabs Minimalistas

```css
.tabs-wrapper-minimal {
    display: flex;
    background: #f8fafc;
    border-radius: 12px;
    padding: 6px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    max-width: 400px;
    margin: 0 auto;
}

.tab-minimal.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    transform: translateY(-1px);
}
```

### 9. Dashboard Container Responsivo

```css
.dashboard-container {
    padding: 24px;
    background: #f8fafc;
    min-height: calc(100vh - 58px);
}

/* Para vista de equipo - 33% menos ancho + 15% más = 82% */
.dashboard-container.team-view {
    width: 82%;
    max-width: 82%;
    margin: 0 auto;
}
```

## Funcionalidades Implementadas

### 1. Despliegue Automático
- **Comando inicial**: `./deploy.sh` (configuración completa)
- **Comando rápido**: `./auto-deploy.sh` (solo cambios)

### 2. Detección Automática de URL
- Funciona en cualquier directorio (`/rinotrack/` o `/rinotrackalfa/`)
- Detección automática de protocolo (HTTP/HTTPS)

### 3. Tabs Funcionales
- **Mis Tareas**: Kanban personal del usuario
- **Equipo**: Kanban de todas las tareas del clan

### 4. Interactividad Mantenida
- Checkboxes funcionales
- Hover effects
- Animaciones suaves
- Click para ir a detalles

## Comandos de Despliegue

### Despliegue Completo (Primera vez)
```bash
./deploy.sh
```

### Despliegue Rápido (Solo cambios)
```bash
./auto-deploy.sh
```

### Verificar Estado del Servidor
```bash
ssh -i rinotrack.pem bitnami@52.3.160.124 "cd /home/bitnami/htdocs/rinotrackalfa && ls -la"
```

## URL de Acceso

🌐 **Aplicación desplegada**: http://52.3.160.124/rinotrackalfa/public/

## Notas Importantes

1. **Base de Datos**: Configurar contraseña en el servidor si es necesario
2. **Permisos**: Los archivos tienen permisos correctos (755 para directorios, 644 para PHP)
3. **Logs**: Errores se registran en `/tmp/rinotrack_errors.log`
4. **Uploads**: Directorio con permisos 777 para subida de archivos

## Mantenimiento del Estilo

Para mantener el estilo visual exacto:

1. **No modificar** las clases CSS principales del kanban
2. **Usar** los colores definidos en la guía
3. **Mantener** la estructura de 4 columnas
4. **Preservar** los gradientes en los headers
5. **Conservar** las animaciones y efectos hover

El sistema está configurado para mantener automáticamente el estilo visual del kanban tal como se muestra en la imagen de referencia proporcionada.
