<?php
/**
 * Configuración de la aplicación - DESARROLLO
 */

// Configuración de la aplicación
define('APP_NAME', 'Polaris');
define('APP_URL', 'https://rinotrack.rinorisk.com/desarrollo/rinotrack/public/');
define('APP_DEBUG', false);

// Configuración de zona horaria
date_default_timezone_set('America/Mexico_City');

// Configuración de sesión
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 1); // HTTPS habilitado
ini_set('session.cookie_samesite', 'Lax');

// Configuración de errores
ini_set('display_errors', 0);
error_reporting(0);
ini_set('log_errors', 1);
ini_set('error_log', '/tmp/rinotrack_desarrollo_errors.log');

// Incluir archivos de configuración
require_once __DIR__ . '/database.php';
require_once __DIR__ . '/mail.php';

// Iniciar sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
