<?php
/**
 * Script para verificar TODAS las asignaciones de Lizet Martija en el proyecto 482
 */

require_once __DIR__ . '/config/database.php';

try {
    $db = Database::getConnection();
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== VERIFICACIÓN COMPLETA DE ASIGNACIONES DE LIZET MARTIJA EN PROYECTO 482 ===\n\n";
    
    // Encontrar el usuario
    $stmt = $db->prepare("
        SELECT user_id, username, email, full_name 
        FROM Users 
        WHERE email = 'auxiliar.rh@rinorisk.com' 
           OR username = 'lizetm' 
           OR full_name LIKE '%Lizet%Martija%'
    ");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "❌ ERROR: No se encontró el usuario\n";
        exit(1);
    }
    
    $userId = $user['user_id'];
    echo "✅ Usuario: {$user['full_name']} (ID: {$userId})\n\n";
    
    // Verificar asignaciones en Task_Assignments
    echo "1. ASIGNACIONES EN Task_Assignments:\n";
    $stmt = $db->prepare("
        SELECT 
            t.task_id,
            t.task_name,
            ta.assigned_percentage
        FROM Task_Assignments ta
        INNER JOIN Tasks t ON ta.task_id = t.task_id
        WHERE t.project_id = 482 AND ta.user_id = ?
    ");
    $stmt->execute([$userId]);
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($assignments) > 0) {
        foreach ($assignments as $a) {
            echo "   - Tarea #{$a['task_id']}: {$a['task_name']} ({$a['assigned_percentage']}%)\n";
        }
    } else {
        echo "   ✅ No hay asignaciones en Task_Assignments\n";
    }
    
    // Verificar asignaciones directas en Tasks (assigned_to_user_id)
    echo "\n2. ASIGNACIONES DIRECTAS EN Tasks (assigned_to_user_id):\n";
    $stmt = $db->prepare("
        SELECT 
            task_id,
            task_name,
            assigned_to_user_id
        FROM Tasks
        WHERE project_id = 482 AND assigned_to_user_id = ?
    ");
    $stmt->execute([$userId]);
    $directAssignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($directAssignments) > 0) {
        foreach ($directAssignments as $a) {
            echo "   - Tarea #{$a['task_id']}: {$a['task_name']} (Asignación directa)\n";
        }
    } else {
        echo "   ✅ No hay asignaciones directas\n";
    }
    
    // Resumen
    $total = count($assignments) + count($directAssignments);
    echo "\n📊 RESUMEN:\n";
    echo "   - Asignaciones en Task_Assignments: " . count($assignments) . "\n";
    echo "   - Asignaciones directas: " . count($directAssignments) . "\n";
    echo "   - TOTAL: {$total}\n";
    
    if ($total > 0) {
        echo "\n⚠️  Se encontraron {$total} asignación(es). ¿Deseas eliminarlas? (s/n): ";
        $handle = fopen("php://stdin", "r");
        $line = trim(fgets($handle));
        fclose($handle);
        
        if (strtolower($line) === 's' || strtolower($line) === 'y' || strtolower($line) === 'si') {
            $db->beginTransaction();
            
            try {
                // Eliminar de Task_Assignments
                if (count($assignments) > 0) {
                    $stmt = $db->prepare("
                        DELETE ta FROM Task_Assignments ta
                        INNER JOIN Tasks t ON ta.task_id = t.task_id
                        WHERE t.project_id = 482 AND ta.user_id = ?
                    ");
                    $stmt->execute([$userId]);
                    echo "✅ Eliminadas " . $stmt->rowCount() . " asignación(es) de Task_Assignments\n";
                }
                
                // Eliminar asignaciones directas (poner NULL)
                if (count($directAssignments) > 0) {
                    $stmt = $db->prepare("
                        UPDATE Tasks 
                        SET assigned_to_user_id = NULL 
                        WHERE project_id = 482 AND assigned_to_user_id = ?
                    ");
                    $stmt->execute([$userId]);
                    echo "✅ Eliminadas " . $stmt->rowCount() . " asignación(es) directas\n";
                }
                
                $db->commit();
                echo "\n✅ ÉXITO: Todas las asignaciones han sido eliminadas\n";
                
            } catch (Exception $e) {
                $db->rollBack();
                throw $e;
            }
        } else {
            echo "❌ Operación cancelada.\n";
        }
    } else {
        echo "\n✅ El usuario no tiene asignaciones en el proyecto 482\n";
    }
    
} catch (Exception $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    exit(1);
}

