<?php
// Guardar el contenido en una variable
ob_start();

// Preparar variables para el tablero kanban (compatibilidad con nombres de columnas)
$vencidas = $kanbanTasks['vencidas'] ?? [];
$hoy = $kanbanTasks['hoy'] ?? [];
$semana = $kanbanTasks['1_semana'] ?? []; // Mapear 1_semana a semana
$futuras = $kanbanTasks['2_semanas'] ?? []; // Mapear 2_semanas a futuras
$totalTasks = count($vencidas) + count($hoy) + count($semana) + count($futuras);
?>

<!-- MONDAY.COM THEME - Solo para estilos del contenido -->
<link rel="stylesheet" href="<?= APP_URL ?>/assets/css/monday-theme.css?v=<?= time() ?>">
<!-- FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Lottie para animaciones -->
<script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.5/dist/dotlottie-wc.js" type="module"></script>

<style>
/* Ajustar padding para que el contenido no se pierda en los bordes */
.monday-main {
    padding: 0 1rem 0 0 !important;
    margin: 0 !important;
}

/* Responsive */
@media (max-width: 768px) {
    .monday-main {
        padding: 0 0.5rem 0 0 !important;
    }
}
</style>

<div class="monday-layout">
    <!-- MAIN CONTENT -->
    <main class="monday-main">
        <!-- HEADER -->
        <header class="main-header">
            <div class="header-title-row">
                <div>
                    <h1 class="page-title">Hola, <?= htmlspecialchars($user['full_name'] ?? 'Colaborador') ?>! 👋</h1>
                    <p style="color: var(--monday-text-secondary); margin-top: 5px;">Aquí está lo que está pasando en tu clan hoy.</p>
                </div>
                <div class="header-actions">
                    <button class="btn-monday btn-secondary" onclick="location.reload()">
                        <i class="fas fa-sync-alt"></i> Actualizar
                    </button>
                    <button class="btn-monday btn-primary" onclick="openCreateTaskModal()">
                        <i class="fas fa-plus"></i> Tarea
                    </button>
                </div>
            </div>
        </header>

        <!-- STATS CARDS -->
        <div class="stats-container">
            <div class="stat-card" style="position: relative; overflow: hidden;">
                <div class="stat-value" id="stat-total" style="color: var(--monday-primary); position: relative; z-index: 1;"><?= $totalTasks ?? 0 ?></div>
                <img src="<?php echo Utils::asset('assets/img/iconos_dashboard/total_tareas.png'); ?>" alt="Total Tareas" style="width: 60px; height: 60px; object-fit: contain; opacity: 0.25; position: absolute; top: 50%; right: 10px; transform: translateY(-50%); z-index: 0; pointer-events: none;">
                <div class="stat-label" style="position: relative; z-index: 1;">
                    Total Tareas
                </div>
            </div>
            <div class="stat-card" style="position: relative; overflow: hidden;">
                <div class="stat-value" id="stat-vencidas" style="color: var(--status-stuck); position: relative; z-index: 1;"><?= count($vencidas ?? []) ?></div>
                <img src="<?php echo Utils::asset('assets/img/iconos_dashboard/vencidas.png'); ?>" alt="Vencidas" style="width: 60px; height: 60px; object-fit: contain; opacity: 0.25; position: absolute; top: 50%; right: 10px; transform: translateY(-50%); z-index: 0; pointer-events: none;">
                <div class="stat-label" style="position: relative; z-index: 1;">
                    Vencidas
                </div>
            </div>
            <div class="stat-card" style="position: relative; overflow: hidden;">
                <div class="stat-value" id="stat-hoy" style="color: var(--status-working); position: relative; z-index: 1;"><?= count($hoy ?? []) ?></div>
                <img src="<?php echo Utils::asset('assets/img/iconos_dashboard/hoy.png'); ?>" alt="Para Hoy" style="width: 60px; height: 60px; object-fit: contain; opacity: 0.25; position: absolute; top: 50%; right: 10px; transform: translateY(-50%); z-index: 0; pointer-events: none;">
                <div class="stat-label" style="position: relative; z-index: 1;">
                    Para Hoy
                </div>
            </div>
            <div class="stat-card" style="position: relative; overflow: hidden;">
                <div class="stat-value" id="stat-semana" style="color: var(--status-todo); position: relative; z-index: 1;"><?= count($semana ?? []) ?></div>
                <img src="<?php echo Utils::asset('assets/img/iconos_dashboard/esta_semana.png'); ?>" alt="Esta Semana" style="width: 60px; height: 60px; object-fit: contain; opacity: 0.25; position: absolute; top: 50%; right: 10px; transform: translateY(-50%); z-index: 0; pointer-events: none;">
                <div class="stat-label" style="position: relative; z-index: 1;">
                    Esta Semana
                </div>
            </div>
            <div class="stat-card" style="position: relative; overflow: hidden;">
                <div class="stat-value" id="stat-futuras" style="color: var(--status-done); position: relative; z-index: 1;"><?= count($futuras ?? []) ?></div>
                <img src="<?php echo Utils::asset('assets/img/iconos_dashboard/futuras.png'); ?>" alt="Futuras" style="width: 60px; height: 60px; object-fit: contain; opacity: 0.25; position: absolute; top: 50%; right: 10px; transform: translateY(-50%); z-index: 0; pointer-events: none;">
                <div class="stat-label" style="position: relative; z-index: 1;">
                    Futuras
                </div>
            </div>
        </div>

        <!-- TAB NAVIGATION -->
        <div class="tabs-container">
            <div class="tabs-wrapper">
                <button class="tab-button active" data-tab="my-tasks" onclick="switchTab('my-tasks')">
                    <i class="fas fa-user"></i>
                    <span>Mis Tareas</span>
                </button>
            </div>
        </div>

        <!-- BOARD VIEW - MIS TAREAS -->
        <div id="my-tasks-board" class="board-container tab-content active">
            <div class="kanban-wrapper">
                <!-- Column: Vencidas -->
                <div class="kanban-column">
                    <div class="column-header stuck">
                        <span>Vencidas</span>
                        <span class="count"><?= count($vencidas ?? []) ?></span>
                    </div>
                    <div class="column-body">
                        <?php if (!empty($vencidas)): ?>
                            <?php foreach ($vencidas as $task): ?>
                                <?php $isSubtask = ($task['item_type'] ?? '') === 'subtask'; ?>
                                <div class="task-card priority-high <?= $isSubtask ? 'is-subtask' : '' ?>">
                                    <div class="task-card-header">
                                        <div class="task-checkbox" onclick="event.stopPropagation(); toggleTaskCompletion(<?= $task['task_id'] ?>, this);">
                                            <input type="checkbox" <?= ($task['status'] === 'completed') ? 'checked' : '' ?>>
                                        </div>
                                        <div class="task-due-date" style="color: var(--status-stuck); font-weight: bold;">
                                            <?= date('d M', strtotime($task['due_date'])) ?>
                                        </div>
                                        <?php if (!empty($task['project_name'])): ?>
                                            <div class="project-tag" title="<?= htmlspecialchars($task['project_name']) ?>">
                                                <?= htmlspecialchars($task['project_name']) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="task-content" onclick="viewTaskDetails(<?= $task['task_id'] ?>)">
                                        <?php if ($isSubtask): ?>
                                            <div class="subtask-badge">
                                                <i class="fas fa-level-down-alt"></i> Subtarea
                                            </div>
                                        <?php endif; ?>
                                        <div class="task-title"><?= htmlspecialchars($task['task_name']) ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div style="text-align: center; padding: 20px; color: #999; font-size: 12px;">No hay tareas vencidas</div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Column: Hoy -->
                <div class="kanban-column">
                    <div class="column-header working">
                        <span>Hoy</span>
                        <span class="count"><?= count($hoy ?? []) ?></span>
                    </div>
                    <div class="column-body">
                        <?php if (!empty($hoy)): ?>
                            <?php foreach ($hoy as $task): ?>
                                <?php $isSubtask = ($task['item_type'] ?? '') === 'subtask'; ?>
                                <div class="task-card priority-medium <?= $isSubtask ? 'is-subtask' : '' ?>">
                                    <div class="task-card-header">
                                        <div class="task-checkbox" onclick="event.stopPropagation(); toggleTaskCompletion(<?= $task['task_id'] ?>, this);">
                                            <input type="checkbox" <?= ($task['status'] === 'completed') ? 'checked' : '' ?>>
                                        </div>
                                        <div class="task-due-date">
                                            <?= date('d M', strtotime($task['due_date'])) ?>
                                        </div>
                                        <?php if (!empty($task['project_name'])): ?>
                                            <div class="project-tag" title="<?= htmlspecialchars($task['project_name']) ?>">
                                                <?= htmlspecialchars($task['project_name']) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="task-content" onclick="viewTaskDetails(<?= $task['task_id'] ?>)">
                                        <?php if ($isSubtask): ?>
                                            <div class="subtask-badge">
                                                <i class="fas fa-level-down-alt"></i> Subtarea
                                            </div>
                                        <?php endif; ?>
                                        <div class="task-title"><?= htmlspecialchars($task['task_name']) ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div style="text-align: center; padding: 20px; color: #999; font-size: 12px;">No hay tareas para hoy</div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Column: Esta Semana -->
                <div class="kanban-column">
                    <div class="column-header todo">
                        <span>Esta Semana</span>
                        <span class="count"><?= count($semana ?? []) ?></span>
                    </div>
                    <div class="column-body">
                        <?php if (!empty($semana)): ?>
                            <?php foreach ($semana as $task): ?>
                                <?php $isSubtask = ($task['item_type'] ?? '') === 'subtask'; ?>
                                <div class="task-card priority-low <?= $isSubtask ? 'is-subtask' : '' ?>">
                                    <div class="task-card-header">
                                        <div class="task-checkbox" onclick="event.stopPropagation(); toggleTaskCompletion(<?= $task['task_id'] ?>, this);">
                                            <input type="checkbox" <?= ($task['status'] === 'completed') ? 'checked' : '' ?>>
                                        </div>
                                        <div class="task-due-date">
                                            <?= date('d M', strtotime($task['due_date'])) ?>
                                        </div>
                                        <?php if (!empty($task['project_name'])): ?>
                                            <div class="project-tag" title="<?= htmlspecialchars($task['project_name']) ?>">
                                                <?= htmlspecialchars($task['project_name']) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="task-content" onclick="viewTaskDetails(<?= $task['task_id'] ?>)">
                                        <?php if ($isSubtask): ?>
                                            <div class="subtask-badge">
                                                <i class="fas fa-level-down-alt"></i> Subtarea
                                            </div>
                                        <?php endif; ?>
                                        <div class="task-title"><?= htmlspecialchars($task['task_name']) ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div style="text-align: center; padding: 20px; color: #999; font-size: 12px;">No hay tareas para esta semana</div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Column: Futuras -->
                <div class="kanban-column">
                    <div class="column-header done">
                        <span>Futuras</span>
                        <span class="count"><?= count($futuras ?? []) ?></span>
                    </div>
                    <div class="column-body">
                        <?php if (!empty($futuras)): ?>
                            <?php foreach ($futuras as $task): ?>
                                <?php $isSubtask = ($task['item_type'] ?? '') === 'subtask'; ?>
                                <div class="task-card priority-low <?= $isSubtask ? 'is-subtask' : '' ?>">
                                    <div class="task-card-header">
                                        <div class="task-checkbox" onclick="event.stopPropagation(); toggleTaskCompletion(<?= $task['task_id'] ?>, this);">
                                            <input type="checkbox" <?= ($task['status'] === 'completed') ? 'checked' : '' ?>>
                                        </div>
                                        <div class="task-due-date">
                                            <?= date('d M', strtotime($task['due_date'])) ?>
                                        </div>
                                        <?php if (!empty($task['project_name'])): ?>
                                            <div class="project-tag" title="<?= htmlspecialchars($task['project_name']) ?>">
                                                <?= htmlspecialchars($task['project_name']) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="task-content" onclick="viewTaskDetails(<?= $task['task_id'] ?>)">
                                        <?php if ($isSubtask): ?>
                                            <div class="subtask-badge">
                                                <i class="fas fa-level-down-alt"></i> Subtarea
                                            </div>
                                        <?php endif; ?>
                                        <div class="task-title"><?= htmlspecialchars($task['task_name']) ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div style="text-align: center; padding: 20px; color: #999; font-size: 12px;">No hay tareas futuras</div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </main>
</div>

<!-- Scripts -->
<script>
(function() {
    'use strict';
    
    window.viewTaskDetails = function(taskId) {
        // Redirect to task details page
        window.location.href = '?route=clan_member/task-details&task_id=' + taskId;
    };
    
    window.toggleTaskCompletion = function(taskId, checkboxContainer) {
        const checkbox = checkboxContainer.querySelector('input[type="checkbox"]');
        const isCompleted = checkbox.checked;
        
        // Find the task card
        const card = checkboxContainer.closest('.task-card');
        
        if (isCompleted) {
            // Primero mostrar el GIF Checked.gif en el centro del card
            showCheckAnimationOnCheckbox(checkboxContainer);
            
            // Deshabilitar el checkbox durante la animación
            checkbox.disabled = true;
            
            // Ocultar el contenido del card pero mantener visible
            const cardContent = card.querySelector('.task-card-header, .task-card-body');
            if (cardContent) {
                cardContent.style.opacity = '0.3';
            }
            
            // Enviar petición AJAX
            fetch('<?= APP_URL ?>simple-complete-task.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `task_id=${taskId}&completed=1`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Mostrar animación de celebración a pantalla completa
                    showCompletionAnimation();
                    
                    // Después de 1 segundo (tiempo del GIF), hacer fade-out del card
                    setTimeout(() => {
                        card.style.transition = 'all 0.3s ease-out';
                        card.style.opacity = '0';
                        card.style.transform = 'translateX(20px)';
                        card.style.maxHeight = card.offsetHeight + 'px';
                        
                        // Remover el card después de la animación de fade-out
                        setTimeout(() => {
                            card.style.maxHeight = '0';
                            card.style.marginBottom = '0';
                            card.style.padding = '0';
                            setTimeout(() => {
                                card.remove();
                                
                                // Update task counts
                                updateColumnCounts();
                            }, 300);
                        }, 300);
                    }, 1000);
                } else {
                    // Revertir en caso de error
                    checkbox.checked = false;
                    checkbox.disabled = false;
                    if (cardContent) {
                        cardContent.style.opacity = '1';
                    }
                    card.style.opacity = '1';
                    card.style.transform = 'translateX(0)';
                    card.style.maxHeight = '';
                    // Remover animación si está presente
                    const existingAnim = card.querySelector('[id^="checkboxCheckAnimation"]');
                    if (existingAnim) {
                        existingAnim.remove();
                    }
                    showErrorModal(data.message || 'Error al actualizar la tarea');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                checkbox.checked = false;
                checkbox.disabled = false;
                if (cardContent) {
                    cardContent.style.opacity = '1';
                }
                card.style.opacity = '1';
                card.style.transform = 'translateX(0)';
                card.style.maxHeight = '';
                // Remover animación si está presente
                const existingAnim = card.querySelector('[id^="checkboxCheckAnimation"]');
                if (existingAnim) {
                    existingAnim.remove();
                }
                showErrorModal('Error de conexión');
            });
        } else {
            // Unmarking as completed - just update DB, keep visible
            fetch('<?= APP_URL ?>simple-complete-task.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `task_id=${taskId}&completed=0`
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    checkbox.checked = true;
                    showErrorModal(data.message || 'Error al actualizar la tarea');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                checkbox.checked = true;
                showErrorModal('Error de conexión');
            });
        }
    };
    
    function updateColumnCounts() {
        // Update count badges for each column
        document.querySelectorAll('.kanban-column').forEach(column => {
            const count = column.querySelectorAll('.task-card').length;
            const badge = column.querySelector('.count');
            if (badge) {
                badge.textContent = count;
            }
        });
    }
    
    window.switchTab = function(tabName) {
        console.log('Switching to tab:', tabName);
        
        // Update tab buttons
        document.querySelectorAll('.tab-button').forEach(btn => {
            btn.classList.remove('active');
        });
        document.querySelector(`[data-tab="${tabName}"]`)?.classList.add('active');
        
        // Update content visibility
        document.querySelectorAll('.tab-content').forEach(content => {
            content.style.display = 'none';
        });
        
        if (tabName === 'my-tasks') {
            document.getElementById('my-tasks-board').style.display = 'block';
        }
    };
})();

// Función para abrir modal de crear tarea personal
function openCreateTaskModal() {
    console.log('🔄 Abrir modal crear tarea personal');
    const modal = document.getElementById('createTaskModal');
    if (modal) {
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
        
        // Establecer fecha mínima como hoy
        const today = new Date().toISOString().split('T')[0];
        const dueDateField = document.getElementById('task_due_date');
        if (dueDateField) {
            dueDateField.setAttribute('min', today);
        }
    }
}

// Función para cerrar modal
function closeCreateTaskModal() {
    const modal = document.getElementById('createTaskModal');
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
        // Limpiar formulario
        const form = document.getElementById('createTaskForm');
        if (form) {
            form.reset();
        }
        // Re-habilitar botones al cerrar
        enableModalButtons();
    }
}

// Función para crear tarea personal
function createPersonalTask() {
    const form = document.getElementById('createTaskForm');
    const formData = new FormData(form);
    
    // Validaciones básicas
    const taskName = formData.get('task_name');
    const dueDate = formData.get('due_date');
    
    if (!taskName || taskName.trim() === '') {
        showErrorModal('Por favor ingresa un nombre para la tarea');
        return;
    }
    
    if (!dueDate) {
        showErrorModal('Por favor selecciona una fecha de vencimiento');
        return;
    }
    
    // Deshabilitar botones para evitar doble clic
    disableModalButtons();
    
    // Mostrar loader
    showLoader();
    
    console.log('📝 Creando tarea personal:', taskName);
    
    fetch('?route=clan_member/create-personal-task', {
        method: 'POST',
        credentials: 'same-origin',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('✅ Tarea personal creada exitosamente');
            
            // Ocultar loader y mostrar animación de check
            hideLoader();
            showCheckAnimation();
            
            // Después de 3 segundos, cerrar modal y recargar
            setTimeout(() => {
                hideCheckAnimation();
                closeCreateTaskModal();
                window.location.reload();
            }, 3000);
        } else {
            console.error('❌ Error:', data.message);
            hideLoader();
            enableModalButtons(); // Re-habilitar botones en caso de error
            showErrorModal('Error al crear tarea personal: ' + (data.message || 'Error desconocido'));
        }
    })
    .catch(error => {
        console.error('❌ Error:', error);
        hideLoader();
        enableModalButtons(); // Re-habilitar botones en caso de error
        showErrorModal('Error de conexión al crear tarea personal');
    });
}

// Función para deshabilitar botones del modal
function disableModalButtons() {
    const cancelBtn = document.querySelector('.modal-footer .btn-secondary');
    const createBtn = document.querySelector('.modal-footer .btn-primary');
    
    if (cancelBtn) {
        cancelBtn.disabled = true;
        cancelBtn.style.opacity = '0.5';
        cancelBtn.style.cursor = 'not-allowed';
        cancelBtn.style.pointerEvents = 'none';
    }
    
    if (createBtn) {
        createBtn.disabled = true;
        createBtn.style.opacity = '0.5';
        createBtn.style.cursor = 'not-allowed';
        createBtn.style.pointerEvents = 'none';
    }
}

// Función para habilitar botones del modal
function enableModalButtons() {
    const cancelBtn = document.querySelector('.modal-footer .btn-secondary');
    const createBtn = document.querySelector('.modal-footer .btn-primary');
    
    if (cancelBtn) {
        cancelBtn.disabled = false;
        cancelBtn.style.opacity = '1';
        cancelBtn.style.cursor = 'pointer';
        cancelBtn.style.pointerEvents = 'auto';
    }
    
    if (createBtn) {
        createBtn.disabled = false;
        createBtn.style.opacity = '1';
        createBtn.style.cursor = 'pointer';
        createBtn.style.pointerEvents = 'auto';
    }
}

// Función para mostrar loader
function showLoader() {
    const modalBody = document.querySelector('.modal-body');
    if (!modalBody) return;
    
    const loader = document.createElement('div');
    loader.id = 'taskLoader';
    loader.innerHTML = `
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(252, 252, 253, 0.9); backdrop-filter: blur(10px); display: flex; align-items: center; justify-content: center; z-index: 1000; border-radius: 12px;">
            <img src="<?php echo Utils::asset('assets/img/Task_Loader.gif'); ?>" alt="Loading" style="width: 120px; height: 120px;">
        </div>
    `;
    modalBody.style.position = 'relative';
    modalBody.appendChild(loader);
}

// Función para ocultar loader
function hideLoader() {
    const loader = document.getElementById('taskLoader');
    if (loader) {
        loader.remove();
    }
}

// Función para mostrar animación de check
function showCheckAnimation() {
    const modalBody = document.querySelector('.modal-body');
    if (!modalBody) return;
    
    const checkAnim = document.createElement('div');
    checkAnim.id = 'checkAnimation';
    checkAnim.innerHTML = `
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(252, 252, 253, 0.95); backdrop-filter: blur(10px); display: flex; flex-direction: column; align-items: center; justify-content: center; z-index: 1001; border-radius: 12px; animation: fadeIn 0.3s ease-in;">
            <img src="<?php echo Utils::asset('assets/img/Check.gif'); ?>" alt="Success" style="max-width: 100%; height: auto;">
            <p style="margin-top: 20px; font-size: 1.1rem; font-weight: 600; color: #059669; animation: fadeIn 0.5s ease-in 0.3s both;">¡Recordatorio creado exitosamente!</p>
        </div>
    `;
    modalBody.style.position = 'relative';
    modalBody.appendChild(checkAnim);
}

// Función para ocultar animación de check
function hideCheckAnimation() {
    const checkAnim = document.getElementById('checkAnimation');
    if (checkAnim) {
        checkAnim.style.animation = 'fadeOut 0.3s ease-out';
        setTimeout(() => {
            checkAnim.remove();
        }, 300);
    }
}

// Función para mostrar modal de error
function showErrorModal(message) {
    const modal = document.getElementById('errorModal');
    const messageElement = document.getElementById('errorModalMessage');
    
    if (modal && messageElement) {
        messageElement.textContent = message;
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
    } else {
        alert(message);
    }
}

// Función para cerrar modal de error
function closeErrorModal() {
    const modal = document.getElementById('errorModal');
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
    }
}

// Función para mostrar animación Checked.gif cuando se marca un checkbox
function showCheckAnimationOnCheckbox(checkboxContainer) {
    const card = checkboxContainer.closest('.task-card');
    
    if (!card) return;
    
    // Asegurar que el card tenga position relative
    if (getComputedStyle(card).position === 'static') {
        card.style.position = 'relative';
    }
    
    // Remover animación previa si existe
    const existingAnim = card.querySelector('[id^="checkboxCheckAnimation"]');
    if (existingAnim) {
        existingAnim.remove();
    }
    
    // Crear overlay para la animación en el centro del card
    const overlay = document.createElement('div');
    overlay.id = 'checkboxCheckAnimation_' + Date.now();
    overlay.style.cssText = `
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1000;
        pointer-events: none;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(252, 252, 253, 0.95);
        backdrop-filter: blur(5px);
        border-radius: inherit;
        animation: fadeIn 0.2s ease-in;
    `;
    
    overlay.innerHTML = `
        <img src="<?php echo Utils::asset('assets/img/Checked.gif'); ?>" alt="Checked" style="max-width: 200px; max-height: 200px; width: auto; height: auto;">
    `;
    
    card.appendChild(overlay);
    
    // Remover después de 1 segundo
    setTimeout(() => {
        overlay.style.animation = 'fadeOut 0.3s ease-out';
        setTimeout(() => {
            overlay.remove();
        }, 300);
    }, 1000);
}

// Función para mostrar animación de completado a pantalla completa
function showCompletionAnimation() {
    console.log('🎉 Mostrando animación de celebración');
    
    // Remover overlay anterior si existe
    const existingOverlay = document.getElementById('completion-animation-overlay');
    if (existingOverlay) {
        existingOverlay.remove();
    }
    
    // Crear overlay
    const overlay = document.createElement('div');
    overlay.id = 'completion-animation-overlay';
    overlay.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.4);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 99999;
        opacity: 0;
        transition: opacity 0.3s ease;
    `;
    
    // Crear el elemento lottie
    const lottiePlayer = document.createElement('dotlottie-wc');
    lottiePlayer.setAttribute('src', 'https://lottie.host/3fb875a8-1324-4e18-bb92-116a8e77a2d7/E2KxUaNO1B.lottie');
    lottiePlayer.setAttribute('autoplay', '');
    lottiePlayer.style.cssText = 'width: 350px; height: 350px;';
    
    overlay.appendChild(lottiePlayer);
    document.body.appendChild(overlay);
    
    // Mostrar con animación
    requestAnimationFrame(() => {
        overlay.style.opacity = '1';
    });
    
    // Ocultar después de 3 segundos
    setTimeout(() => {
        overlay.style.opacity = '0';
        setTimeout(() => {
            overlay.remove();
        }, 300);
    }, 3000);
    
    console.log('🎉 Animación creada y mostrada');
}

// Cerrar modal con ESC
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        const modal = document.getElementById('createTaskModal');
        if (modal && modal.style.display === 'flex') {
            closeCreateTaskModal();
        }
        
        const errorModal = document.getElementById('errorModal');
        if (errorModal && errorModal.style.display === 'flex') {
            closeErrorModal();
        }
    }
});

// Cerrar modales al hacer clic fuera de ellos
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('createTaskModal');
    if (modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === this) {
                closeCreateTaskModal();
            }
        });
    }
    
    const errorModal = document.getElementById('errorModal');
    if (errorModal) {
        errorModal.addEventListener('click', function(e) {
            if (e.target === this) {
                closeErrorModal();
            }
        });
    }
});
</script>

<!-- Modal para crear tarea personal -->
<div id="createTaskModal" class="modal-overlay" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <div style="display: flex; align-items: center; gap: 12px;">
                <img src="<?php echo Utils::asset('assets/img/Task_Loader.gif'); ?>" alt="Loading" style="width: 96px; height: 96px;">
                <h3>Agregar Recordatorio </h3>
            </div>
            <button type="button" class="modal-close" onclick="closeCreateTaskModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <form id="createTaskForm" class="modal-body">
            <!-- Campo oculto para marcar como tarea personal -->
            <input type="hidden" name="is_personal" value="1">
            <!-- Campo oculto para asignar la tarea al usuario actual -->
            <input type="hidden" name="user_id" value="<?php echo $_SESSION['user_id']; ?>">
            
            <div class="form-group">
                <label for="task_name">Nombre del Recordatorio *</label>
                <input type="text" id="task_name" name="task_name" class="form-control" required>
            </div>
            
            <div class="form-group">
                <label for="task_description">Descripción</label>
                <textarea id="task_description" name="description" class="form-control" rows="3"></textarea>
            </div>
            
            <div class="form-group">
                <label for="task_due_date">Fecha de Vencimiento *</label>
                <input type="date" id="task_due_date" name="due_date" class="form-control" required>
            </div>
            
            <div class="form-group">
                <label for="task_priority">Prioridad</label>
                <select id="task_priority" name="priority" class="form-control">
                    <option value="low">Baja</option>
                    <option value="medium" selected>Media</option>
                    <option value="high">Alta</option>
                </select>
            </div>
        </form>
        
        <div class="modal-footer">
            <button type="button" class="btn-secondary" onclick="closeCreateTaskModal()">
                <i class="fas fa-times"></i>
                Cancelar
            </button>
            <button type="button" class="btn-primary" onclick="createPersonalTask()">
                <i class="fas fa-plus"></i>
                Crear Recordatorio
            </button>
        </div>
    </div>
</div>

<!-- Modal de Error/Notificación -->
<div id="errorModal" class="error-modal-overlay" style="display: none;">
    <div class="error-modal-content">
        <div class="error-modal-header">
            <div class="error-icon">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <button type="button" class="error-modal-close" onclick="closeErrorModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="error-modal-body">
            <p id="errorModalMessage" class="error-message"></p>
        </div>
        
        <div class="error-modal-footer">
            <button type="button" class="error-btn-primary" onclick="closeErrorModal()">
                <i class="fas fa-check"></i>
                Entendido
            </button>
        </div>
    </div>
</div>

<style>
/* Estilos para el modal - Efecto Crystal/Glassmorphism estilo macOS */
.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(15, 23, 42, 0.6);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
    animation: fadeIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

.modal-content {
    background: rgba(252, 252, 253, 0.9);
    backdrop-filter: blur(40px) saturate(105%);
    -webkit-backdrop-filter: blur(40px) saturate(105%);
    border-radius: 20px;
    width: 90%;
    max-width: 500px;
    max-height: 90vh;
    overflow: hidden;
    box-shadow: 
        0 8px 32px rgba(16, 185, 129, 0.04),
        0 0 0 1px rgba(255, 255, 255, 0.4) inset,
        0 1px 2px rgba(0, 0, 0, 0.05);
    border: 1px solid rgba(236, 253, 245, 0.08);
    animation: scaleIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    display: flex;
    flex-direction: column;
}

.modal-content::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 100%;
    background: linear-gradient(
        135deg,
        rgba(236, 253, 245, 0.02) 0%,
        rgba(209, 250, 229, 0.01) 50%,
        rgba(252, 252, 253, 0.01) 100%
    );
    pointer-events: none;
    border-radius: 20px;
}

@keyframes scaleIn {
    from {
        opacity: 0;
        transform: scale(0.95) translateY(20px);
    }
    to {
        opacity: 1;
        transform: scale(1) translateY(0);
    }
}

@keyframes fadeOut {
    from {
        opacity: 1;
    }
    to {
        opacity: 0;
    }
}

.modal-header {
    padding: 24px 28px;
    border-bottom: 1px solid rgba(236, 253, 245, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: linear-gradient(to bottom, rgba(252, 252, 253, 0.6), rgba(236, 253, 245, 0.08));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
    flex-shrink: 0;
}

.modal-header > div {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
    min-width: 0;
}

.modal-header > div img {
    flex-shrink: 0;
}

.modal-header h3 {
    flex: 1;
    min-width: 0;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    margin: 0;
    font-size: 1.3rem;
    font-weight: 600;
    background: linear-gradient(135deg, #1e293b 0%, #475569 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    letter-spacing: -0.02em;
}

.modal-close {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.2);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    font-size: 1.25rem;
    color: #ef4444;
    cursor: pointer;
    padding: 0;
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 10px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.modal-close:hover {
    background: rgba(239, 68, 68, 0.2);
    border-color: rgba(239, 68, 68, 0.4);
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
}

.modal-body {
    padding: 28px;
    overflow-y: auto;
    position: relative;
    z-index: 1;
    background: rgba(252, 252, 253, 0.4);
    flex: 1;
    min-height: 0;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #1e293b;
    font-size: 0.9rem;
    letter-spacing: -0.01em;
}

.form-control {
    width: 100%;
    padding: 12px 16px;
    background: rgba(255, 255, 255, 0.8);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    border: 1px solid rgba(236, 253, 245, 0.15);
    border-radius: 12px;
    font-size: 0.95rem;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    color: #1e293b;
}

.form-control::placeholder {
    color: rgba(148, 163, 184, 0.6);
}

.form-control:focus {
    outline: none;
    background: rgba(255, 255, 255, 0.9);
    border-color: rgba(16, 185, 129, 0.15);
    box-shadow: 
        0 0 0 3px rgba(16, 185, 129, 0.04),
        0 4px 12px rgba(16, 185, 129, 0.05);
    transform: translateY(-1px);
}

.modal-footer {
    padding: 20px 28px 24px;
    border-top: 1px solid rgba(236, 253, 245, 0.1);
    display: flex;
    gap: 12px;
    justify-content: flex-end;
    background: linear-gradient(to top, rgba(252, 252, 253, 0.6), rgba(236, 253, 245, 0.08));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
    flex-shrink: 0;
}

.btn-secondary {
    padding: 12px 24px;
    border: 1px solid rgba(226, 232, 240, 0.5);
    background: rgba(255, 255, 255, 0.7);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    color: #475569;
    border-radius: 10px;
    cursor: pointer;
    font-size: 0.9rem;
    font-weight: 600;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.9);
    border-color: rgba(59, 130, 246, 0.5);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
}

.btn-primary {
    padding: 12px 28px;
    border: none;
    background: linear-gradient(135deg, #059669 0%, #10b981 100%);
    color: white;
    border-radius: 10px;
    cursor: pointer;
    font-size: 0.9rem;
    font-weight: 600;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 
        0 4px 12px rgba(16, 185, 129, 0.3),
        0 0 0 1px rgba(255, 255, 255, 0.1) inset;
    position: relative;
    overflow: hidden;
}

.btn-primary::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.5s;
}

.btn-primary:hover::before {
    left: 100%;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #047857 0%, #059669 100%);
    transform: translateY(-2px);
    box-shadow: 
        0 8px 20px rgba(16, 185, 129, 0.4),
        0 0 0 1px rgba(255, 255, 255, 0.2) inset;
}

.btn-primary:active {
    transform: translateY(0);
}

/* Scrollbar personalizado para el modal body */
.modal-body::-webkit-scrollbar {
    width: 8px;
}

.modal-body::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.05);
    border-radius: 10px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: rgba(148, 163, 184, 0.3);
    border-radius: 10px;
}

.modal-body::-webkit-scrollbar-thumb:hover {
    background: rgba(148, 163, 184, 0.5);
}

/* Responsive para el modal */
@media (max-width: 768px) {
    .modal-content {
        width: 95%;
        max-width: 95%;
        max-height: 95vh;
        margin: 10px;
    }
    
    .modal-header {
        padding: 16px 20px;
    }
    
    .modal-header > div img {
        width: 48px !important;
        height: 48px !important;
    }
    
    .modal-header h3 {
        font-size: 1.1rem;
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-footer {
        padding: 16px 20px;
        flex-wrap: wrap;
    }
    
    .btn-primary, .btn-secondary {
        padding: 10px 20px;
        font-size: 0.85rem;
        flex: 1;
        min-width: 120px;
    }
}

@media (max-width: 480px) {
    .modal-content {
        width: 100%;
        max-width: 100%;
        max-height: 100vh;
        margin: 0;
        border-radius: 0;
    }
    
    .modal-header {
        padding: 12px 16px;
    }
    
    .modal-header > div img {
        width: 40px !important;
        height: 40px !important;
    }
    
    .modal-header h3 {
        font-size: 1rem;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .modal-footer {
        padding: 12px 16px;
        flex-direction: column;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        padding: 12px;
    }
}

@media (max-height: 600px) {
    .modal-content {
        max-height: 98vh;
    }
    
    .modal-header {
        padding: 12px 20px;
    }
    
    .modal-header > div img {
        width: 40px !important;
        height: 40px !important;
    }
    
    .modal-body {
        padding: 16px 20px;
    }
    
    .modal-footer {
        padding: 12px 20px;
    }
}

/* Estilos para el Modal de Error/Notificación */
.error-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(15, 23, 42, 0.6);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10001;
    animation: fadeIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.error-modal-content {
    background: rgba(252, 252, 253, 0.95);
    backdrop-filter: blur(40px) saturate(105%);
    -webkit-backdrop-filter: blur(40px) saturate(105%);
    border-radius: 20px;
    width: 90%;
    max-width: 450px;
    box-shadow: 
        0 8px 32px rgba(239, 68, 68, 0.15),
        0 0 0 1px rgba(255, 255, 255, 0.4) inset,
        0 1px 2px rgba(0, 0, 0, 0.05);
    border: 1px solid rgba(254, 242, 242, 0.3);
    animation: scaleIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.error-modal-content::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 100%;
    background: linear-gradient(
        135deg,
        rgba(254, 242, 242, 0.05) 0%,
        rgba(252, 252, 253, 0.02) 50%,
        rgba(252, 252, 253, 0.01) 100%
    );
    pointer-events: none;
    border-radius: 20px;
}

.error-modal-header {
    padding: 24px 28px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: linear-gradient(to bottom, rgba(254, 242, 242, 0.3), rgba(252, 252, 253, 0.1));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
}

.error-icon {
    width: 56px;
    height: 56px;
    background: linear-gradient(135deg, rgba(239, 68, 68, 0.15), rgba(220, 38, 38, 0.1));
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 
        0 4px 12px rgba(239, 68, 68, 0.2),
        0 0 0 1px rgba(239, 68, 68, 0.1) inset;
}

.error-icon i {
    font-size: 1.75rem;
    color: #ef4444;
    animation: pulse 2s ease-in-out infinite;
}

@keyframes pulse {
    0%, 100% {
        transform: scale(1);
        opacity: 1;
    }
    50% {
        transform: scale(1.05);
        opacity: 0.9;
    }
}

.error-modal-close {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.2);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    font-size: 1.25rem;
    color: #ef4444;
    cursor: pointer;
    padding: 0;
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 10px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.error-modal-close:hover {
    background: rgba(239, 68, 68, 0.2);
    border-color: rgba(239, 68, 68, 0.4);
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.2);
}

.error-modal-body {
    padding: 24px 28px;
    text-align: center;
}

.error-message {
    margin: 0;
    font-size: 1.05rem;
    line-height: 1.6;
    color: #1e293b;
    font-weight: 500;
}

.error-modal-footer {
    padding: 20px 28px 24px;
    border-top: 1px solid rgba(254, 242, 242, 0.2);
    display: flex;
    justify-content: center;
    background: linear-gradient(to top, rgba(254, 242, 242, 0.2), rgba(252, 252, 253, 0.1));
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    position: relative;
    z-index: 1;
}

.error-btn-primary {
    padding: 12px 32px;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 1rem;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: #ffffff;
    border: none;
    box-shadow: 
        0 4px 12px rgba(239, 68, 68, 0.3),
        0 0 0 1px rgba(255, 255, 255, 0.1) inset;
    position: relative;
    overflow: hidden;
}

.error-btn-primary::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.5s;
}

.error-btn-primary:hover::before {
    left: 100%;
}

.error-btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 
        0 6px 16px rgba(239, 68, 68, 0.4),
        0 0 0 1px rgba(255, 255, 255, 0.15) inset;
}

.error-btn-primary:active {
    transform: translateY(0);
}

/* Cerrar modal al hacer clic fuera de él */
.error-modal-overlay {
    cursor: pointer;
}

.error-modal-content {
    cursor: default;
}

/* Responsive para el modal de error */
@media (max-width: 600px) {
    .error-modal-content {
        width: 95%;
        margin: 0 10px;
    }
    .error-modal-header, .error-modal-footer {
        padding: 15px 20px;
    }
    .error-message {
        font-size: 0.95rem;
    }
    .error-btn-primary {
        padding: 10px 24px;
        font-size: 0.9rem;
    }
}
</style>

<?php
$content = ob_get_clean();
require_once __DIR__ . '/../layout.php';
?>

