<?php
// Capturar el contenido de la vista
ob_start();
?>

<style>
/* ============================================
   ESTILOS ESPECÍFICOS PARA EL PANEL DE ADMIN
   ============================================ */

/* Reset básico para admin */
* {
    box-sizing: border-box;
}

body {
    margin: 0;
    padding: 0;
    font-family: 'Inter', 'Segoe UI', system-ui, sans-serif;
    background: #f8fafc;
    color: #1e293b;
    line-height: 1.6;
}

/* Variables CSS para admin */
:root {
    --admin-primary: #6366f1;
    --admin-primary-dark: #4f46e5;
    --admin-secondary: #10b981;
    --admin-bg-primary: #ffffff;
    --admin-bg-secondary: #f8fafc;
    --admin-bg-tertiary: #f1f5f9;
    --admin-bg-accent: #e2e8f0;
    --admin-text-primary: #1e293b;
    --admin-text-secondary: #64748b;
    --admin-text-muted: #94a3b8;
    --admin-border: #e2e8f0;
    --admin-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    --admin-shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    --admin-radius: 12px;
    --admin-radius-lg: 20px;
    --admin-spacing: 1rem;
    --admin-spacing-lg: 1.5rem;
    --admin-spacing-xl: 2rem;
}

/* Dashboard moderno */
.modern-dashboard {
    min-height: 100vh;
    background: var(--admin-bg-secondary);
    margin-left: 260px; /* Espacio para el sidebar */
    transition: margin-left 0.3s ease;
}

/* Ajuste cuando el sidebar está colapsado */
html.sidebar-collapsed .modern-dashboard {
    margin-left: 64px;
}

/* Contenido principal */
.main-content {
    max-width: 1400px;
    margin: 0 auto;
    padding: var(--admin-spacing-xl) var(--admin-spacing-lg);
}

/* Headers */
.welcome-header, .page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--admin-spacing-xl);
    padding: var(--admin-spacing-xl);
    background: var(--admin-bg-primary);
    border-radius: var(--admin-radius-lg);
    box-shadow: var(--admin-shadow);
    border: 1px solid var(--admin-border);
}

.welcome-title, .page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--admin-text-primary);
    margin: 0;
    display: flex;
    align-items: center;
    gap: var(--admin-spacing);
}

.welcome-subtitle {
    font-size: 1.1rem;
    color: var(--admin-text-secondary);
    margin: var(--admin-spacing) 0 0 0;
}

/* Botones */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: var(--admin-spacing);
    padding: var(--admin-spacing) var(--admin-spacing-lg);
    border: none;
    border-radius: var(--admin-radius);
    font-weight: 500;
    text-decoration: none;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.95rem;
}

.btn-primary {
    background: linear-gradient(135deg, var(--admin-primary) 0%, var(--admin-secondary) 100%);
    color: white;
    box-shadow: var(--admin-shadow);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: var(--admin-shadow-lg);
}

.btn-secondary {
    background: var(--admin-bg-primary);
    color: var(--admin-text-primary);
    border: 2px solid var(--admin-border);
}

.btn-secondary:hover {
    border-color: var(--admin-primary);
    color: var(--admin-primary);
}

/* Grid de estadísticas */
.stats-section {
    margin-bottom: var(--admin-spacing-xl);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: var(--admin-spacing-xl);
}

.stat-card {
    background: var(--admin-bg-primary);
    border-radius: var(--admin-radius-lg);
    padding: var(--admin-spacing-xl);
    box-shadow: var(--admin-shadow);
    border: 1px solid var(--admin-border);
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: var(--admin-shadow-lg);
}

.stat-card.gradient-bg {
    background: linear-gradient(135deg, var(--admin-primary) 0%, var(--admin-secondary) 100%);
    color: white;
}

.stat-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--admin-spacing-lg);
}

.stat-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0;
}

.stat-header i {
    font-size: 1.5rem;
    opacity: 0.8;
}

.stat-number {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: var(--admin-spacing);
    line-height: 1;
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: var(--admin-spacing);
    font-size: 0.9rem;
    opacity: 0.8;
}

.stat-trend i {
    font-size: 1rem;
}

/* Secciones de contenido */
.content-section {
    margin-bottom: var(--admin-spacing-xl);
}

.content-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: var(--admin-spacing-xl);
}

.content-card {
    background: var(--admin-bg-primary);
    border-radius: var(--admin-radius-lg);
    padding: var(--admin-spacing-xl);
    box-shadow: var(--admin-shadow);
    border: 1px solid var(--admin-border);
    transition: all 0.3s ease;
}

.content-card:hover {
    transform: translateY(-3px);
    box-shadow: var(--admin-shadow-lg);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--admin-spacing-lg);
    padding-bottom: var(--admin-spacing);
    border-bottom: 2px solid var(--admin-bg-tertiary);
}

.card-header h3 {
    display: flex;
    align-items: center;
    gap: var(--admin-spacing);
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--admin-text-primary);
    margin: 0;
}

/* Estilos específicos del dashboard */
.action-buttons {
    display: flex;
    flex-direction: column;
    gap: var(--admin-spacing);
    margin-top: var(--admin-spacing-lg);
}

.role-stats {
    display: flex;
    flex-direction: column;
    gap: var(--admin-spacing);
    margin-top: var(--admin-spacing-lg);
}

.role-item {
    padding: var(--admin-spacing);
    background: var(--admin-bg-tertiary);
    border-radius: var(--admin-radius);
    border: 1px solid var(--admin-border);
}

.role-info {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.role-name {
    font-weight: 500;
    color: var(--admin-text-primary);
    text-transform: capitalize;
}

.role-count {
    font-size: 0.9rem;
    color: var(--admin-text-muted);
}

.role-bar {
    height: 8px;
    background: var(--admin-border);
    border-radius: 9999px;
    overflow: hidden;
}

.role-progress {
    height: 100%;
    background: linear-gradient(135deg, var(--admin-primary) 0%, var(--admin-secondary) 100%);
    border-radius: 9999px;
    transition: width 0.3s ease;
}

/* Iconos con gradiente */
.icon-gradient {
    background: linear-gradient(135deg, var(--admin-primary) 0%, var(--admin-secondary) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

/* Animaciones */
.animate-fade-in {
    animation: fadeIn 0.6s ease-out forwards;
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive */
@media (max-width: 768px) {
    .modern-dashboard {
        margin-left: 0 !important; /* En móvil, sin margen */
    }
    
    .welcome-header,
    .page-header {
        flex-direction: column;
        text-align: center;
        gap: var(--admin-spacing-lg);
    }
    
    .welcome-title,
    .page-title {
        font-size: 2rem;
    }
    
    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    }
    
    .content-grid {
        grid-template-columns: 1fr;
    }
    
    .main-content {
        padding: var(--admin-spacing-lg) var(--admin-spacing);
    }
    
    .action-buttons {
        flex-direction: column;
    }
}
</style>

<div class="modern-dashboard" data-theme="default">
    <!-- Contenido principal -->
    <main class="main-content">
        <!-- Header de bienvenida -->
        <header class="welcome-header animate-fade-in">
            <div class="welcome-content">
                <h1 class="welcome-title">
                    🚀 Panel de Administración
                </h1>
                <p class="welcome-subtitle">
                    Gestiona usuarios, proyectos y clanes desde un solo lugar.
                </p>
            </div>
        </header>

        <!-- Grid de estadísticas principales -->
        <section class="stats-section animate-fade-in">
            <div class="stats-grid">
                <!-- Estadísticas de Usuarios -->
                <div class="stat-card gradient-bg">
                    <div class="stat-content">
                        <div class="stat-header">
                            <h3>Usuarios</h3>
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-number"><?php echo $userStats['total_users']; ?></div>
                        <div class="stat-trend">
                            <i class="fas fa-check-circle"></i>
                            <span><?php echo $userStats['active_users']; ?> activos</span>
                        </div>
                    </div>
                </div>

                <!-- Estadísticas de Proyectos -->
                <div class="stat-card">
                    <div class="stat-content">
                        <div class="stat-header">
                            <h3>Proyectos</h3>
                            <i class="fas fa-project-diagram"></i>
                        </div>
                        <div class="stat-number"><?php echo $projectStats['total_projects']; ?></div>
                        <div class="stat-trend positive">
                            <i class="fas fa-arrow-up"></i>
                            <span><?php echo $projectStats['open_projects']; ?> abiertos</span>
                        </div>
                    </div>
                </div>

                <!-- Estadísticas de Clanes -->
                <div class="stat-card">
                    <div class="stat-content">
                        <div class="stat-header">
                            <h3>Clanes</h3>
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <div class="stat-number"><?php echo $clanStats['total_clans']; ?></div>
                        <div class="stat-trend">
                            <i class="fas fa-chart-line"></i>
                            <span>Promedio: <?php echo number_format((float)($clanStats['avg_members_per_clan'] ?? 0), 1); ?> miembros</span>
                        </div>
                    </div>
                </div>

                <!-- Progreso Promedio -->
                <div class="stat-card">
                    <div class="stat-content">
                        <div class="stat-header">
                            <h3>Progreso Promedio</h3>
                            <i class="fas fa-percentage"></i>
                        </div>
                        <div class="stat-number"><?php echo number_format((float)($projectStats['avg_progress'] ?? 0), 1); ?>%</div>
                        <div class="stat-trend positive">
                            <i class="fas fa-trophy"></i>
                            <span>Rendimiento del sistema</span>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Acciones rápidas -->
        <section class="content-section animate-fade-in">
            <div class="content-grid">
                <!-- Acciones de Usuario -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-user-plus icon-gradient"></i>
                            Gestión de Usuarios
                        </h3>
                    </div>
                    <div class="action-buttons">
                        <a href="?route=admin/users" class="btn btn-primary">
                            <i class="fas fa-users"></i>
                            Ver Usuarios
                        </a>
                        <a href="?route=admin/users" class="btn btn-secondary">
                            <i class="fas fa-user-plus"></i>
                            Crear Usuario
                        </a>
                    </div>
                </div>

                <!-- Acciones de Proyecto -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-project-diagram icon-gradient"></i>
                            Gestión de Proyectos
                        </h3>
                    </div>
                    <div class="action-buttons">
                        <a href="?route=admin/projects" class="btn btn-primary">
                            <i class="fas fa-list"></i>
                            Ver Proyectos
                        </a>
                        <a href="?route=admin/projects" class="btn btn-secondary">
                            <i class="fas fa-plus"></i>
                            Crear Proyecto
                        </a>
                    </div>
                </div>

                <!-- Acciones de Clan -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-users-cog icon-gradient"></i>
                            Gestión de Clanes
                        </h3>
                    </div>
                    <div class="action-buttons">
                        <a href="?route=admin/clans" class="btn btn-primary">
                            <i class="fas fa-eye"></i>
                            Ver Clanes
                        </a>
                        <a href="?route=admin/clans" class="btn btn-secondary">
                            <i class="fas fa-plus"></i>
                            Crear Clan
                        </a>
                    </div>
                </div>

                <!-- Distribución de Roles -->
                <div class="content-card">
                    <div class="card-header">
                        <h3>
                            <i class="fas fa-chart-pie icon-gradient"></i>
                            Distribución de Roles
                        </h3>
                    </div>
                    <div class="role-stats">
                        <?php foreach ($roleStats as $role): ?>
                        <div class="role-item">
                            <div class="role-info">
                                <span class="role-name"><?php echo Utils::escape($role['role_name']); ?></span>
                                <span class="role-count"><?php echo $role['user_count']; ?> usuarios</span>
                            </div>
                            <div class="role-bar">
                                <div class="role-progress" style="width: <?php echo ($userStats['total_users'] > 0) ? ($role['user_count'] / $userStats['total_users'] * 100) : 0; ?>%"></div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
    </main>
</div>



<?php
// Guardar el contenido en una variable
$content = ob_get_clean();

// Configurar variables para el layout
$title = 'Panel de Administración - ' . APP_NAME;

// Incluir el layout del admin
include __DIR__ . '/layout.php';
?>