<?php
// Guardar el contenido en una variable
ob_start();
?>

<!-- MONDAY.COM THEME - Mismo tema que el dashboard -->
<link rel="stylesheet" href="<?= APP_URL ?>/assets/css/monday-theme.css?v=<?= time() ?>">
<!-- FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="monday-layout">
    <main class="monday-main" style="margin-left: 0; width: 100%;">
    <!-- HEADER -->
    <header class="main-header">
        <div class="header-title-row">
            <div>
                <h1 class="page-title">Gestión de Miembros</h1>
                <p style="color: var(--monday-text-secondary); margin-top: 5px;">Administra los miembros de <?php echo htmlspecialchars($clan['clan_name'] ?? 'tu clan'); ?></p>
            </div>
            <div class="header-actions">
                <button class="btn-monday btn-primary btn-green" onclick="openAddMemberModal()">
                    <i class="fas fa-plus"></i>
                    Agregar Miembro
                </button>
            </div>
        </div>
        
        <!-- Búsqueda -->
        <div class="search-container-monday" style="margin-top: 20px;">
            <div class="search-input-monday">
                    <i class="fas fa-search"></i>
                <input type="text" id="searchInput" value="<?php echo htmlspecialchars($search ?? ''); ?>" 
                       placeholder="Buscar miembros..." autocomplete="off">
                <button type="button" id="clearSearch" class="btn-clear-monday" style="<?php echo empty($search) ? 'display: none;' : ''; ?>">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="search-loading-monday" id="searchLoading" style="display: none;">
                <i class="fas fa-spinner fa-spin"></i>
            </div>
        </div>
    </header>

    <!-- Contenido Principal -->
    <div class="board-container">
            <?php if (!empty($members)): ?>
            <!-- Vista de Lista de Miembros -->
            <section class="members-list-view animate-fade-in" id="membersView">
                <div class="projects-table-minimal">
                    <div class="table-header-minimal">
                        <div class="header-cell">Miembro</div>
                        <div class="header-cell">Usuario</div>
                        <div class="header-cell">Email</div>
                        <div class="header-cell">Estado</div>
                        <div class="header-cell">Acciones</div>
                    </div>
                    
                    <?php foreach ($members as $member): ?>
                    <div class="table-row-minimal member-row">
                        <div class="cell-project">
                            <div class="project-icon-list">
                                    <?php if (!empty($member['avatar_path']) && $member['avatar_path'] !== ''): ?>
                                        <img src="<?php echo APP_URL . htmlspecialchars($member['avatar_path']); ?>" 
                                             alt="<?php echo htmlspecialchars($member['full_name']); ?>" 
                                         class="member-avatar-table"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                    <div class="member-initials-table" style="display: none;" data-user-id="<?php echo $member['user_id']; ?>">
                                            <?php echo strtoupper(substr($member['full_name'], 0, 1)); ?>
                                        </div>
                                    <?php else: ?>
                                    <div class="member-initials-table" data-user-id="<?php echo $member['user_id']; ?>">
                                            <?php echo strtoupper(substr($member['full_name'], 0, 1)); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <div class="project-info-list">
                                <div class="project-name-list member-name"><?php echo htmlspecialchars($member['full_name']); ?></div>
                                </div>
                            </div>
                            
                        <div class="cell-status">
                            <span class="username-badge">@<?php echo htmlspecialchars($member['username']); ?></span>
                        </div>
                        
                        <div class="cell-progress">
                            <span class="email-text"><?php echo htmlspecialchars($member['email']); ?></span>
                        </div>
                        
                        <div class="cell-tasks">
                                <?php if ($member['is_active']): ?>
                                <span class="status-badge status-active">
                                    <i class="fas fa-circle"></i>
                                    Activo
                                </span>
                                <?php else: ?>
                                <span class="status-badge status-inactive">
                                    <i class="fas fa-circle"></i>
                                    Inactivo
                                </span>
                                <?php endif; ?>
                            </div>
                            
                        <div class="cell-actions">
                                <?php if ($member['user_id'] != $user['user_id']): ?>
                                <div class="actions-list">
                                    <div class="dropdown-container">
                                        <button class="btn-list-action menu" onclick="toggleListMenu(<?php echo $member['user_id']; ?>)" title="Más opciones">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu-list" id="listMenu<?php echo $member['user_id']; ?>">
                                            <button class="menu-item-list danger" onclick="removeMember(<?php echo $member['user_id']; ?>, '<?php echo htmlspecialchars($member['full_name']); ?>')">
                                        <i class="fas fa-user-minus"></i>
                                                Remover del clan
                                    </button>
                                        </div>
                                    </div>
                                </div>
                                <?php else: ?>
                                <span class="leader-badge-table">
                                    <i class="fas fa-crown"></i>
                                    Líder del Clan
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Paginación -->
                <?php if (isset($pagination) && $pagination['totalPages'] > 1): ?>
                <div class="pagination-container-monday">
                    <div class="pagination-info-monday">
                        Mostrando <?= count($members) ?> de <?= $pagination['totalMembers'] ?> miembros
                    </div>
                    <div class="pagination-controls-monday">
                        <button class="btn-pagination-monday" 
                                onclick="goToPage(<?= max(1, $pagination['currentPage'] - 1) ?>)"
                                <?= $pagination['currentPage'] <= 1 ? 'disabled' : '' ?>>
                            <i class="fas fa-chevron-left"></i>
                            Anterior
                        </button>
                        
                        <div class="pagination-pages-monday">
                            <?php
                            $start = max(1, $pagination['currentPage'] - 2);
                            $end = min($pagination['totalPages'], $pagination['currentPage'] + 2);
                            
                            if ($start > 1): ?>
                                <button class="btn-page-monday" onclick="goToPage(1)">1</button>
                                <?php if ($start > 2): ?>
                                    <span class="pagination-ellipsis">...</span>
                                <?php endif;
                            endif;
                            
                            for ($i = $start; $i <= $end; $i++): ?>
                                <button class="btn-page-monday <?= $i == $pagination['currentPage'] ? 'active' : '' ?>" 
                                        onclick="goToPage(<?= $i ?>)">
                                    <?= $i ?>
                                </button>
                            <?php endfor;
                            
                            if ($end < $pagination['totalPages']): ?>
                                <?php if ($end < $pagination['totalPages'] - 1): ?>
                                    <span class="pagination-ellipsis">...</span>
                                <?php endif; ?>
                                <button class="btn-page-monday" onclick="goToPage(<?= $pagination['totalPages'] ?>)">
                                    <?= $pagination['totalPages'] ?>
                                </button>
                            <?php endif; ?>
                        </div>
                        
                        <button class="btn-pagination-monday" 
                                onclick="goToPage(<?= min($pagination['totalPages'], $pagination['currentPage'] + 1) ?>)"
                                <?= $pagination['currentPage'] >= $pagination['totalPages'] ? 'disabled' : '' ?>>
                            Siguiente
                            <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </section>
        <?php else: ?>
            <!-- Estado vacío -->
            <div class="empty-state-monday">
                <div class="empty-icon-monday">
                    👥
    </div>
                <h3>No hay miembros en el clan</h3>
                <p>Agrega miembros para comenzar a colaborar en equipo</p>
                <button class="btn-monday btn-primary btn-green" onclick="openAddMemberModal()">
                    <i class="fas fa-plus"></i>
                    Agregar primer miembro
                </button>
            </div>
        <?php endif; ?>
        
        <!-- Animación Lottie -->
        <div class="lottie-animation-container">
            <script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.5/dist/dotlottie-wc.js" type="module"></script>
            <dotlottie-wc src="https://lottie.host/1729f11c-071b-4930-bd3b-7e83916b30df/IthmBJGPUh.lottie" 
                          style="width: 300px; height: 300px; margin: 20px auto; display: block;" 
                          autoplay loop>
            </dotlottie-wc>
        </div>
    </div>
    </main>
</div>

<!-- Modal para agregar miembro -->
<div id="addMemberModal" class="modal-overlay-monday" style="display: none;">
    <div class="modal-content-monday">
        <div class="modal-header-monday">
            <h3>
                <i class="fas fa-user-plus"></i>
                Agregar Miembro al Clan
            </h3>
            <button class="modal-close-monday" onclick="closeAddMemberModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="modal-body-monday">
            <form id="addMemberForm" class="form-monday">
                <div class="form-group-monday">
                    <label for="userId" class="form-label-monday">
                        <i class="fas fa-user"></i>
                        Seleccionar Usuario *
                    </label>
                    <div class="select-search-container">
                        <input type="text" id="userSearch" placeholder="Buscar usuario..." class="form-input-monday">
                        <select id="userId" name="userId" style="display: none;">
                        <option value="">Seleccionar usuario...</option>
                        <!-- Se llenará dinámicamente -->
                    </select>
                        <div id="userDropdown" class="select-dropdown">
                            <!-- Se llenará dinámicamente -->
                        </div>
                    </div>
                    <small class="form-help-monday">Escribe para buscar, haz clic en un usuario o presiona Enter para seleccionar</small>
                </div>
            </form>
        </div>
        
        <div class="modal-footer-monday">
            <button type="button" class="btn-monday btn-secondary" onclick="closeAddMemberModal()">
                <i class="fas fa-times"></i>
                Cancelar
            </button>
            <button type="submit" form="addMemberForm" class="btn-monday btn-primary">
                <i class="fas fa-plus"></i>
                Agregar Miembro
            </button>
        </div>
    </div>
</div>

<!-- Modal de Notificación Personalizado -->
<div id="customNotificationModal" class="modal-overlay-monday" style="display: none;">
    <div class="notification-modal-content">
        <div class="notification-header">
            <span id="notificationTitle">Notificación</span>
        </div>
        <div class="notification-body">
            <div class="notification-icon">
                <i id="notificationIcon" class="fas fa-info-circle"></i>
            </div>
            <div class="notification-message">
                <span id="notificationMessage">Mensaje</span>
            </div>
        </div>
        <div class="notification-footer">
            <button type="button" class="btn-monday btn-primary" onclick="closeCustomNotification()">
                Aceptar
            </button>
        </div>
    </div>
</div>

<script>
// Variables globales para búsqueda
let searchTimeout;

// ============================================
// FUNCIONES GLOBALES (disponibles inmediatamente)
// ============================================

// Función para navegación de páginas
function goToPage(page) {
    const url = new URL(window.location);
    url.searchParams.set('page', page);
    
    // Mantener el término de búsqueda si existe
    const searchInput = document.getElementById('searchInput');
    if (searchInput && searchInput.value) {
        url.searchParams.set('search', searchInput.value);
    }
    
    window.location.href = url.toString();
}

// Función para toggle del dropdown de acciones
function toggleListMenu(memberId) {
    const dropdown = document.getElementById('listMenu' + memberId);
    if (!dropdown) {
        console.error('Dropdown no encontrado para memberId:', memberId);
        return;
    }
    
    const isOpen = dropdown.style.display === 'block';
    
    // Cerrar todos los dropdowns
    document.querySelectorAll('.dropdown-menu-list').forEach(menu => {
        menu.style.display = 'none';
    });
    
    // Abrir el dropdown actual si estaba cerrado
    if (!isOpen) {
        // Posicionar el dropdown
        const button = dropdown.previousElementSibling;
        const rect = button.getBoundingClientRect();
        
        dropdown.style.position = 'fixed';
        dropdown.style.top = (rect.bottom + 5) + 'px';
        dropdown.style.left = (rect.left - 120) + 'px'; // Ajustar para que no se salga
        dropdown.style.display = 'block';
        dropdown.style.zIndex = '999999';
        
        console.log('Dropdown abierto para memberId:', memberId);
    }
}

// Función para remover miembro
function removeMember(userId, memberName) {
    if (confirm(`¿Estás seguro de que deseas remover a ${memberName} del clan?`)) {
        fetch('?route=clan_leader/remove-member', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                user_id: userId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showCustomNotification(data.message, 'success', '¡Éxito!');
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                showCustomNotification(data.message, 'error', 'Error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showCustomNotification('Error de conexión', 'error', 'Error');
        });
    }
}

// Funciones para el modal de agregar miembro
function openAddMemberModal() {
    console.log('Abriendo modal de agregar miembro...');
    const modal = document.getElementById('addMemberModal');
    if (!modal) {
        console.error('Modal no encontrado');
        return;
    }
    
    modal.style.display = 'flex';
    
    // Resetear el estado
    if (typeof userSearchInput !== 'undefined' && userSearchInput) userSearchInput.value = '';
    if (typeof userIdSelect !== 'undefined' && userIdSelect) userIdSelect.value = '';
    if (typeof selectedUserId !== 'undefined') selectedUserId = null;
    if (typeof allUsers !== 'undefined') allUsers = [];
    if (typeof userDropdown !== 'undefined' && userDropdown) {
        userDropdown.innerHTML = '';
        userDropdown.classList.remove('show');
    }
    
    // Cargar usuarios
    loadAvailableUsers();
}

function closeAddMemberModal() {
    const modal = document.getElementById('addMemberModal');
    if (modal) modal.style.display = 'none';
    
    if (typeof userSearchInput !== 'undefined' && userSearchInput) userSearchInput.value = '';
    if (typeof userIdSelect !== 'undefined' && userIdSelect) userIdSelect.value = '';
    if (typeof selectedUserId !== 'undefined') selectedUserId = null;
    if (typeof allUsers !== 'undefined') allUsers = [];
    if (typeof userDropdown !== 'undefined' && userDropdown) {
        userDropdown.innerHTML = '';
        userDropdown.classList.remove('show');
    }
}

// Funciones para el modal de notificación personalizado
function showCustomNotification(message, type = 'info', title = 'Notificación') {
    const modal = document.getElementById('customNotificationModal');
    if (!modal) return;
    
    const titleElement = document.getElementById('notificationTitle');
    const messageElement = document.getElementById('notificationMessage');
    const iconElement = document.getElementById('notificationIcon');
    
    // Configurar el título
    if (titleElement) titleElement.textContent = title;
    
    // Configurar el mensaje
    if (messageElement) messageElement.textContent = message;
    
    // Configurar el icono según el tipo
    if (iconElement) {
        const iconContainer = iconElement.parentElement;
        if (iconContainer) iconContainer.className = 'custom-notification-icon ' + type;
        
        switch(type) {
            case 'success':
                iconElement.className = 'fas fa-check-circle';
                if (titleElement) titleElement.textContent = '¡Éxito!';
                break;
            case 'error':
                iconElement.className = 'fas fa-exclamation-circle';
                if (titleElement) titleElement.textContent = 'Error';
                break;
            case 'warning':
                iconElement.className = 'fas fa-exclamation-triangle';
                if (titleElement) titleElement.textContent = 'Advertencia';
                break;
            case 'info':
            default:
                iconElement.className = 'fas fa-info-circle';
                if (titleElement) titleElement.textContent = 'Información';
                break;
        }
    }
    
    // Mostrar el modal
    modal.style.display = 'flex';
}

function closeCustomNotification() {
    const modal = document.getElementById('customNotificationModal');
    if (!modal) return;
    
    const titleElement = document.getElementById('notificationTitle');
    const title = titleElement ? titleElement.textContent : '';
    
    // Si es un mensaje de éxito, cerrar también el modal de agregar miembro y recargar
    if (title === '¡Éxito!') {
        closeAddMemberModal();
        // Recargar la página para mostrar el nuevo miembro
        window.location.reload();
    } else {
        modal.style.display = 'none';
    }
}

// Función para realizar búsqueda con debounce
function performSearch(searchTerm) {
    console.log('performSearch llamado con:', searchTerm);
    
    // Limpiar timeout anterior
    if (searchTimeout) {
        clearTimeout(searchTimeout);
    }
    
    // Si el término está vacío, mostrar todos los miembros
    if (!searchTerm.trim()) {
        console.log('Término vacío, limpiando búsqueda');
        clearSearch();
        return;
    }
    
    console.log('Iniciando búsqueda para:', searchTerm);
    
    // Mostrar loading
    showSearchLoading(true);
    
    // Configurar timeout para evitar demasiadas peticiones
    searchTimeout = setTimeout(() => {
        console.log('Ejecutando búsqueda después del debounce');
        
        // Actualizar URL y recargar
        const url = new URL(window.location);
        url.searchParams.set('search', searchTerm.trim());
        url.searchParams.delete('page'); // Reset page when searching
        
        console.log('Redirigiendo a:', url.toString());
        window.location.href = url.toString();
        
    }, 800); // 800ms de debounce como en proyectos
    }
    
    // Función para limpiar búsqueda
    function clearSearch() {
    const searchInput = document.getElementById('searchInput');
    const clearBtn = document.getElementById('clearSearch');
    
        searchInput.value = '';
    clearBtn.style.display = 'none';
    
    // Recargar la página sin parámetros de búsqueda
    const url = new URL(window.location);
    url.searchParams.delete('search');
    url.searchParams.delete('page');
    window.location.href = url.toString();
}

// Función para mostrar/ocultar loading
function showSearchLoading(show) {
    const loading = document.getElementById('searchLoading');
    if (loading) {
        loading.style.display = show ? 'flex' : 'none';
    }
}

// Variables globales
const APP_URL = '<?php echo APP_URL; ?>';
let userSearchInput, userDropdown, userIdSelect, allUsers = [], selectedUserId = null;

// Función para cargar usuarios disponibles
function loadAvailableUsers() {
    console.log('Cargando usuarios disponibles...');
    
    if (!userDropdown) {
        console.error('userDropdown no está definido');
        return;
    }
    
    // Mostrar estado de carga
    userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;"><i class="fas fa-spinner fa-spin"></i> Cargando usuarios...</div>';
    userDropdown.classList.add('show');
    
    fetch('?route=clan_leader/get-available-users')
        .then(response => {
            console.log('Respuesta del servidor:', response.status);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Datos recibidos:', data);
            if (data.success) {
                allUsers = data.users;
                console.log('Usuarios cargados:', allUsers.length);
                renderUserDropdown(allUsers);
            } else {
                console.error('Error al cargar usuarios:', data.message);
                userDropdown.innerHTML = '<div class="dropdown-item" style="color: #ef4444; cursor: default;"><i class="fas fa-exclamation-triangle"></i> ' + (data.message || 'Error al cargar usuarios') + '</div>';
                userDropdown.classList.add('show');
            }
        })
        .catch(error => {
            console.error('Error de red:', error);
            userDropdown.innerHTML = '<div class="dropdown-item" style="color: #ef4444; cursor: default;"><i class="fas fa-wifi"></i> Error de conexión</div>';
            userDropdown.classList.add('show');
        });
}

// Función para renderizar el dropdown de usuarios
function renderUserDropdown(users) {
    console.log('Renderizando dropdown con', users.length, 'usuarios');
    if (!userDropdown) return;
    
    userDropdown.innerHTML = '';
    
    if (!users || users.length === 0) {
        userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;">No hay usuarios disponibles</div>';
        userDropdown.classList.add('show');
        return;
    }
    
    users.forEach(user => {
        const item = document.createElement('div');
        item.className = 'dropdown-item';
        item.dataset.userId = user.user_id;
        
        // Generar inicial (solo primera letra)
        const fullName = user.full_name || 'Sin nombre';
        const initial = fullName.charAt(0).toUpperCase();
        
        // Crear avatar
        let avatarHtml = '';
        if (user.avatar_path && user.avatar_path !== '') {
            avatarHtml = `
                <img src="${APP_URL}${user.avatar_path}"
                     alt="${fullName}"
                     class="dropdown-avatar-image"
                     onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                <div class="dropdown-avatar-initials" style="display: none;" data-user-id="${user.user_id}">
                    ${initial}
                </div>
            `;
        } else {
            avatarHtml = `
                <div class="dropdown-avatar-initials" data-user-id="${user.user_id}">
                    ${initial}
                </div>
            `;
        }
        
        item.innerHTML = `
            <div class="dropdown-user-avatar">
                ${avatarHtml}
            </div>
            <div class="user-info">
                <div class="user-name">${fullName}</div>
                <div class="user-email">${user.email || 'Sin email'}</div>
            </div>
        `;
        
        item.addEventListener('click', function() {
            selectUser(user);
        });
        
        userDropdown.appendChild(item);
    });
    
    userDropdown.classList.add('show');
}

// Función para seleccionar un usuario
function selectUser(user) {
    selectedUserId = user.user_id;
    if (userSearchInput) userSearchInput.value = `${user.full_name} (${user.email})`;
    if (userDropdown) userDropdown.classList.remove('show');
    
    // Actualizar el select oculto
    if (userIdSelect) userIdSelect.value = user.user_id;
    
    // Marcar como seleccionado en el dropdown
    document.querySelectorAll('.dropdown-item').forEach(item => {
        item.classList.remove('selected');
        if (item.dataset.userId == user.user_id) {
            item.classList.add('selected');
        }
    });
}
    
    // Función movida fuera del DOMContentLoaded
    
    // Función movida fuera del DOMContentLoaded
    
    // Función movida fuera del DOMContentLoaded

// Funciones ya definidas al inicio del script

// Exponer funciones al objeto global para compatibilidad con atributos inline
window.goToPage = goToPage;
window.toggleListMenu = toggleListMenu;
window.removeMember = removeMember;
window.openAddMemberModal = openAddMemberModal;
window.closeAddMemberModal = closeAddMemberModal;
window.showCustomNotification = showCustomNotification;
window.closeCustomNotification = closeCustomNotification;
window.loadAvailableUsers = loadAvailableUsers;
window.renderUserDropdown = renderUserDropdown;
window.selectUser = selectUser;
window.performSearch = performSearch;
window.clearSearch = clearSearch;
window.showSearchLoading = showSearchLoading;

document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const clearBtn = document.getElementById('clearSearch');
    
    // Inicializar variables del modal
    userSearchInput = document.getElementById('userSearch');
    userDropdown = document.getElementById('userDropdown');
    userIdSelect = document.getElementById('userId');
    
    // Evento para búsqueda en tiempo real
    searchInput.addEventListener('input', function(e) {
        const searchTerm = e.target.value;
        console.log('Input event disparado:', searchTerm);
        
        // Mostrar/ocultar botón limpiar
        if (searchTerm.trim()) {
            clearBtn.style.display = 'block';
        } else {
            clearBtn.style.display = 'none';
        }
        
        // Realizar búsqueda
        performSearch(searchTerm);
    });
    
    // Evento para botón limpiar
    clearBtn.addEventListener('click', function() {
        clearSearch();
    });
    
    // Mostrar botón limpiar si hay búsqueda inicial
    if (searchInput.value.trim()) {
        clearBtn.style.display = 'block';
    }
    
    // Manejar navegación del navegador (atrás/adelante)
    window.addEventListener('popstate', function(e) {
        const urlParams = new URLSearchParams(window.location.search);
        const searchParam = urlParams.get('search') || '';
        searchInput.value = searchParam;
        
        if (searchParam.trim()) {
            clearBtn.style.display = 'block';
            performSearch(searchParam);
        } else {
            clearBtn.style.display = 'none';
            // Recargar página para mostrar todos los miembros
            window.location.reload();
        }
    });
    
    // Hacer la función clearSearch global
    window.clearSearch = clearSearch;
    
    // Función movida fuera del DOMContentLoaded
    
    // Cerrar dropdowns al hacer clic fuera
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.dropdown-container') && !e.target.closest('.btn-list-action')) {
            document.querySelectorAll('.dropdown-menu-list').forEach(menu => {
                menu.style.display = 'none';
            });
        }
    });
    
    // Prevenir que el dropdown se cierre al hacer clic dentro de él
    document.addEventListener('click', function(e) {
        if (e.target.closest('.dropdown-menu-list')) {
            e.stopPropagation();
        }
    });
    
    // Aplicar filtro inicial si hay búsqueda previa
    if (searchInput.value) {
        filterMembers(searchInput.value);
    }
    
    // Funcionalidad del buscador de usuarios en el modal ya inicializada arriba
    
    // Función movida fuera del DOMContentLoaded
    
    // Función movida fuera del DOMContentLoaded
    
    // Función movida fuera del DOMContentLoaded
    
    // Event listeners para el buscador de usuarios
    userSearchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        console.log('Buscando:', searchTerm);
        
        if (searchTerm.length === 0) {
            renderUserDropdown(allUsers);
            selectedUserId = null;
            userIdSelect.value = '';
        } else if (selectedUserId && this.value.includes('(')) {
            // Si el usuario ya está seleccionado, no filtrar
            return;
        } else {
            // Filtrar usuarios
            const filteredUsers = allUsers.filter(user => {
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();
                const username = (user.username || '').toLowerCase();
                
                return fullName.includes(searchTerm) ||
                       email.includes(searchTerm) ||
                       username.includes(searchTerm);
            });
            
            console.log('Usuarios filtrados:', filteredUsers.length);
            
            // Si hay exactamente un usuario que coincide perfectamente, seleccionarlo automáticamente
            if (filteredUsers.length === 1) {
                const user = filteredUsers[0];
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();
                
                // Verificar si el término de búsqueda coincide exactamente con el nombre o email
                if (fullName === searchTerm || email === searchTerm || 
                    fullName.includes(searchTerm) && searchTerm.length >= 3) {
                    console.log('Selección automática de usuario:', user.full_name);
                    selectUser(user);
                    return;
                }
            }
            
            renderUserDropdown(filteredUsers);
        }
    });
    
    userSearchInput.addEventListener('focus', function() {
        if (allUsers.length > 0) {
            userDropdown.classList.add('show');
        } else {
            // Mostrar estado de carga si aún no se han cargado los usuarios
            userDropdown.innerHTML = '<div class="dropdown-item" style="color: #6b7280; cursor: default;">Cargando usuarios...</div>';
            userDropdown.classList.add('show');
        }
    });
    
    // Manejar la tecla Enter para seleccionar el primer usuario disponible
    userSearchInput.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            
            // Buscar usuarios que coincidan con el término actual
            const searchTerm = this.value.toLowerCase().trim();
            const filteredUsers = allUsers.filter(user => {
                const fullName = (user.full_name || '').toLowerCase();
                const email = (user.email || '').toLowerCase();
                const username = (user.username || '').toLowerCase();
                
                return fullName.includes(searchTerm) ||
                       email.includes(searchTerm) ||
                       username.includes(searchTerm);
            });
            
            // Si hay usuarios filtrados, seleccionar el primero
            if (filteredUsers.length > 0) {
                selectUser(filteredUsers[0]);
            } else if (searchTerm.length >= 3) {
                // Si no hay coincidencias pero el término es largo, buscar coincidencias parciales
                const partialMatches = allUsers.filter(user => {
                    const fullName = (user.full_name || '').toLowerCase();
                    const email = (user.email || '').toLowerCase();
                    
                    return fullName.startsWith(searchTerm) || email.startsWith(searchTerm);
                });
                
                if (partialMatches.length > 0) {
                    selectUser(partialMatches[0]);
                } else {
                    showCustomNotification('No se encontró un usuario que coincida con "' + searchTerm + '"', 'warning', 'Usuario no encontrado');
                }
            } else {
                showCustomNotification('Escribe al menos 3 caracteres para buscar usuarios', 'info', 'Búsqueda requerida');
            }
        }
    });
    
    // Cerrar dropdown al hacer clic fuera
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.select-search-container')) {
            userDropdown.classList.remove('show');
        }
    });
    
    // Funciones movidas fuera del DOMContentLoaded
    
    // Funciones movidas fuera del DOMContentLoaded
    
    // Cerrar modal de notificación con tecla Escape
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            const notificationModal = document.getElementById('customNotificationModal');
            if (notificationModal.style.display === 'flex') {
                closeCustomNotification();
            }
        }
    });
    
    // Validación personalizada del formulario
    document.getElementById('addMemberForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        console.log('Validando formulario de agregar miembro...');
        console.log('selectedUserId:', selectedUserId);
        console.log('userIdSelect.value:', userIdSelect.value);
        console.log('userSearchInput.value:', userSearchInput.value);
        
        // Validar que se haya seleccionado un usuario
        if (!selectedUserId || userIdSelect.value === '') {
            // Intentar encontrar el usuario basado en el texto del input
            const searchTerm = userSearchInput.value.trim();
            if (searchTerm.length >= 3) {
                const foundUser = allUsers.find(user => {
                    const fullName = (user.full_name || '').toLowerCase();
                    const email = (user.email || '').toLowerCase();
                    const displayText = `${user.full_name} (${user.email})`.toLowerCase();
                    
                    return fullName === searchTerm.toLowerCase() ||
                           email === searchTerm.toLowerCase() ||
                           displayText === searchTerm.toLowerCase() ||
                           fullName.includes(searchTerm.toLowerCase());
                });
                
                if (foundUser) {
                    console.log('Usuario encontrado automáticamente:', foundUser.full_name);
                    selectUser(foundUser);
                    // Continuar con el envío del formulario
                } else {
                    showCustomNotification('Por favor selecciona un usuario válido de la lista o escribe al menos 3 caracteres y presiona Enter', 'warning', 'Usuario requerido');
                    userSearchInput.focus();
                    return false;
                }
            } else {
                showCustomNotification('Por favor selecciona un usuario para agregar al clan o escribe al menos 3 caracteres y presiona Enter', 'warning', 'Usuario requerido');
                userSearchInput.focus();
                return false;
            }
        }
        
        console.log('Enviando formulario con userId:', selectedUserId);
        console.log('userIdSelect.value:', userIdSelect.value);
        
        // Preparar los datos del formulario
        const formData = new FormData();
        formData.append('userId', selectedUserId);
        
        // También asegurar que el select oculto tenga el valor correcto
        userIdSelect.value = selectedUserId;
        
        console.log('Datos a enviar:', {
            userId: selectedUserId,
            userIdSelectValue: userIdSelect.value,
            url: '?route=clan_leader/add-member'
        });
        
        // Verificar que los datos se están enviando correctamente
        for (let pair of formData.entries()) {
            console.log('FormData:', pair[0] + ': ' + pair[1]);
        }
        
        fetch('?route=clan_leader/add-member', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => {
            console.log('Respuesta del servidor:', response.status, response.statusText);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Datos recibidos:', data);
            if (data.success) {
                showCustomNotification('Usuario agregado al clan exitosamente', 'success', '¡Éxito!');
                // El modal se cerrará manualmente cuando el usuario haga clic en Aceptar
            } else {
                showCustomNotification('Error al agregar usuario: ' + (data.message || 'Error desconocido'), 'error', 'Error');
            }
        })
        .catch(error => {
            console.error('Error completo:', error);
            showCustomNotification('Error de conexión al agregar usuario: ' + error.message, 'error', 'Error de conexión');
        });
    });
    
    // Función movida fuera del DOMContentLoaded
    
    // Función para remover miembro
    window.removeMember = function(userId, memberName) {
        if (confirm(`¿Estás seguro de que deseas remover a ${memberName} del clan?`)) {
            const formData = new FormData();
            formData.append('userId', userId);
            
            fetch('?route=clan_leader/remove-member', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showCustomNotification('Miembro removido del clan exitosamente', 'success', '¡Éxito!');
                    // Recargar la página después de cerrar la notificación
                    setTimeout(() => {
                        window.location.reload();
                    }, 2000);
                } else {
                    showCustomNotification('Error al remover miembro: ' + (data.message || 'Error desconocido'), 'error', 'Error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showCustomNotification('Error de conexión al remover miembro: ' + error.message, 'error', 'Error de conexión');
        });
    }
};

// Funciones ya definidas arriba (duplicado eliminado)
});
</script>

<style>
/* Estilos específicos para miembros usando tema Monday.com */

/* Tabla principal */
.projects-table-minimal {
    background: white;
    border-radius: 16px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
    overflow: visible;
    border: 1px solid rgba(0, 0, 0, 0.05);
    width: 100%;
}

.table-header-minimal {
    display: grid;
    grid-template-columns: 2fr 1fr 1.5fr 1fr 1.5fr;
    gap: 16px;
    padding: 16px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-radius: 16px 16px 0 0;
}

.table-header-minimal > div {
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
}

.table-header-minimal > div:first-child {
    justify-content: flex-start;
    text-align: left;
}

.table-row-minimal {
    display: grid;
    grid-template-columns: 2fr 1fr 1.5fr 1fr 1.5fr;
    gap: 16px;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    transition: all 0.2s ease;
    align-items: center;
}

.table-row-minimal:hover {
    background: linear-gradient(90deg, rgba(102, 126, 234, 0.02) 0%, rgba(118, 75, 162, 0.02) 100%);
}

.table-row-minimal:last-child {
    border-bottom: none;
}

/* Celda de proyecto/miembro */
.cell-project {
    display: flex;
    align-items: center;
    gap: 12px;
}

.project-icon-list {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.project-info-list {
    flex: 1;
    min-width: 0;
}

.project-name-list {
    font-weight: 600;
    color: var(--monday-text-color);
    font-size: 14px;
    line-height: 1.4;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Celdas de contenido */
.cell-status, .cell-progress, .cell-tasks {
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
}

.cell-actions {
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
}

/* Botones de acciones (igual que proyectos) */
.btn-list-action {
    width: 32px;
    height: 32px;
    border: none;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s;
    font-size: 14px;
}

.btn-list-action.menu {
    background: #669AE1;
    color: white;
    border: none;
}

.btn-list-action.menu:hover {
    background: #4a7bc8;
    transform: scale(1.05);
}

/* Dropdown Container para Lista */
.dropdown-container {
    position: relative;
    display: inline-block;
    overflow: visible !important;
    z-index: 1000;
}

.actions-list {
    position: relative;
    overflow: visible !important;
}

/* Paginación */
.pagination-container-monday {
    padding: 20px;
    border-top: 1px solid var(--monday-border);
    background: var(--monday-bg-secondary);
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 16px;
}

.pagination-info-monday {
    font-size: 13px;
    color: var(--monday-text-secondary);
    font-weight: 500;
}

.pagination-controls-monday {
    display: flex;
    align-items: center;
    gap: 8px;
}

.pagination-pages-monday {
    display: flex;
    align-items: center;
    gap: 4px;
}

.btn-pagination-monday, .btn-page-monday {
    padding: 8px 16px;
    border: 1px solid var(--monday-border);
    background: white;
    color: var(--monday-text-color);
    border-radius: var(--border-radius);
    cursor: pointer;
    font-size: 13px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 6px;
    transition: all 0.2s;
    min-width: 36px;
    height: 36px;
    justify-content: center;
}

.btn-pagination-monday:hover:not(:disabled), .btn-page-monday:hover:not(:disabled) {
    background: var(--monday-primary);
    color: white;
    border-color: var(--monday-primary);
}

.btn-pagination-monday:disabled, .btn-page-monday:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

.btn-page-monday.active {
    background: var(--monday-primary);
    color: white;
    border-color: var(--monday-primary);
}

.pagination-ellipsis {
    padding: 0 8px;
    color: var(--monday-text-secondary);
    font-size: 13px;
}

/* Contenedor de animación Lottie */
.lottie-animation-container {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 10px 20px 40px 20px;
    background: transparent;
}

.lottie-animation-container dotlottie-wc {
    filter: drop-shadow(0 4px 20px rgba(0, 0, 0, 0.1));
    border-radius: 16px;
}

/* Loading de búsqueda */
.search-loading-monday {
    display: none;
    align-items: center;
    justify-content: center;
    padding: 8px 16px;
    color: var(--monday-text-secondary);
    font-size: 14px;
    gap: 8px;
}

.search-loading-monday i {
    color: var(--monday-primary);
}
.member-avatar-table {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    object-fit: cover;
}

.member-initials-table {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    background: linear-gradient(135deg, #3b82f6, #2563eb); /* Color por defecto */
}

.username-badge {
    background: var(--monday-bg-secondary);
    color: var(--monday-text-secondary);
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 500;
}

.email-text {
    color: var(--monday-text-secondary);
    font-size: 13px;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 4px 12px;
    border-radius: 16px;
    font-size: 12px;
    font-weight: 500;
}

.status-badge.status-active {
    background: rgba(16, 185, 129, 0.1);
    color: #059669;
}

.status-badge.status-inactive {
    background: rgba(107, 114, 128, 0.1);
    color: #6b7280;
}

.status-badge i {
    font-size: 8px;
}

.leader-badge-table {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: linear-gradient(135deg, #f59e0b, #d97706);
    color: white;
    padding: 6px 12px;
    border-radius: 16px;
    font-size: 12px;
    font-weight: 600;
}

.btn-green {
    background: linear-gradient(135deg, #059669 0%, #10b981 100%) !important;
    color: white !important;
    border: none !important;
    position: relative;
    overflow: hidden;
    z-index: 1;
}

.btn-green::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.5s;
}

.btn-green:hover::before {
    left: 100%;
}

.btn-green:hover {
    background: linear-gradient(135deg, #047857 0%, #059669 100%) !important;
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(16, 185, 129, 0.4), 0 0 0 1px rgba(255, 255, 255, 0.2) inset;
}

.btn-green:active {
    transform: translateY(0);
}

/* Dropdown Menu para Lista (igual que proyectos) */
.dropdown-menu-list {
    display: none;
    position: fixed;
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    min-width: 160px;
    z-index: 999999;
    overflow: hidden;
}

.menu-item-list {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 16px;
    border: none;
    background: none;
    width: 100%;
    text-align: left;
    cursor: pointer;
    transition: background-color 0.2s;
    font-size: 14px;
    color: #374151;
    border-bottom: 1px solid #f3f4f6;
}

.menu-item-list:last-child {
    border-bottom: none;
}

.menu-item-list:hover {
    background: #f9fafb;
}

.menu-item-list.danger {
    color: #ef4444;
}

.menu-item-list.danger:hover {
    background: rgba(239, 68, 68, 0.1);
}

/* Estilos de avatares con colores específicos */
.member-initials-table[data-user-id="1"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.member-initials-table[data-user-id="2"] { background: linear-gradient(135deg, #10b981, #059669); }
.member-initials-table[data-user-id="4"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.member-initials-table[data-user-id="5"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.member-initials-table[data-user-id="6"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.member-initials-table[data-user-id="9"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.member-initials-table[data-user-id="10"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.member-initials-table[data-user-id="11"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.member-initials-table[data-user-id="12"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.member-initials-table[data-user-id="13"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.member-initials-table[data-user-id="14"] { background: linear-gradient(135deg, #a855f7, #9333ea); }
.member-initials-table[data-user-id="15"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.member-initials-table[data-user-id="16"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.member-initials-table[data-user-id="17"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.member-initials-table[data-user-id="18"] { background: linear-gradient(135deg, #10b981, #059669); }
.member-initials-table[data-user-id="19"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.member-initials-table[data-user-id="20"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.member-initials-table[data-user-id="21"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.member-initials-table[data-user-id="22"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.member-initials-table[data-user-id="23"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.member-initials-table[data-user-id="24"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.member-initials-table[data-user-id="25"] { background: linear-gradient(135deg, #a855f7, #9333ea); }
.member-initials-table[data-user-id="26"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.member-initials-table[data-user-id="27"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.member-initials-table[data-user-id="28"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.member-initials-table[data-user-id="29"] { background: linear-gradient(135deg, #10b981, #059669); }
.member-initials-table[data-user-id="30"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }

/* Estilos para el buscador de usuarios */
.select-search-container {
    position: relative;
    width: 100%;
}

.select-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white !important;
    border: 1px solid var(--monday-border);
    border-radius: var(--border-radius);
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    display: none;
    box-shadow: var(--box-shadow);
    min-height: 40px;
}

.select-dropdown.show {
    display: block;
}

.dropdown-item {
    padding: 12px 16px;
    cursor: pointer;
    border-bottom: 1px solid var(--monday-border-light);
    transition: background-color 0.2s ease;
    display: flex;
    align-items: center;
    gap: 12px;
    background: white !important;
    color: var(--monday-text-color) !important;
    min-height: 50px;
}

.dropdown-item:hover {
    background-color: var(--monday-bg-secondary) !important;
}

.dropdown-item:last-child {
    border-bottom: none;
}

.dropdown-item.selected {
    background-color: var(--monday-primary) !important;
    color: white !important;
}

.user-info {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.user-name {
    font-weight: 600;
    font-size: 14px;
}

.user-email {
    color: var(--monday-text-secondary);
    font-size: 12px;
}

.dropdown-item.selected .user-email {
    color: rgba(255, 255, 255, 0.8);
}

/* Estilos para avatares en el dropdown */
.dropdown-user-avatar {
    width: 40px;
    height: 40px;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    background: transparent;
    position: relative;
    flex-shrink: 0;
}

.dropdown-avatar-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
    display: block;
}

.dropdown-avatar-initials {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #3b82f6, #2563eb); /* Color por defecto */
    color: white;
    font-weight: 700;
    font-size: 16px;
    border-radius: 50%;
    text-transform: uppercase;
    letter-spacing: 0;
}

/* Estilos para modales de notificación */
.notification-modal-content {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--box-shadow);
    width: 90%;
    max-width: 400px;
    overflow: hidden;
    animation: modalFadeIn 0.3s ease-out;
}

@keyframes modalFadeIn {
    from {
        opacity: 0;
        transform: scale(0.9) translateY(-20px);
    }
    to {
        opacity: 1;
        transform: scale(1) translateY(0);
    }
}

.notification-header {
    padding: 20px 24px 0;
    text-align: center;
}

.notification-header span {
    font-size: 18px;
    font-weight: 600;
    color: var(--monday-text-color);
}

.notification-body {
    padding: 20px 24px;
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
}

.notification-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
    background: var(--monday-primary);
}

.notification-message {
    color: var(--monday-text-color);
    font-size: 16px;
    line-height: 1.5;
    font-weight: 500;
}

.notification-footer {
    padding: 0 24px 24px;
    display: flex;
    justify-content: center;
}

/* Colores específicos por user_id para las iniciales del dropdown */
.dropdown-avatar-initials[data-user-id="1"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.dropdown-avatar-initials[data-user-id="2"] { background: linear-gradient(135deg, #10b981, #059669); }
.dropdown-avatar-initials[data-user-id="4"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.dropdown-avatar-initials[data-user-id="5"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.dropdown-avatar-initials[data-user-id="6"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.dropdown-avatar-initials[data-user-id="9"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.dropdown-avatar-initials[data-user-id="10"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.dropdown-avatar-initials[data-user-id="11"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.dropdown-avatar-initials[data-user-id="12"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.dropdown-avatar-initials[data-user-id="13"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.dropdown-avatar-initials[data-user-id="14"] { background: linear-gradient(135deg, #a855f7, #9333ea); }
.dropdown-avatar-initials[data-user-id="15"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.dropdown-avatar-initials[data-user-id="16"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.dropdown-avatar-initials[data-user-id="17"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.dropdown-avatar-initials[data-user-id="18"] { background: linear-gradient(135deg, #10b981, #059669); }
.dropdown-avatar-initials[data-user-id="19"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.dropdown-avatar-initials[data-user-id="20"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.dropdown-avatar-initials[data-user-id="21"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.dropdown-avatar-initials[data-user-id="22"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.dropdown-avatar-initials[data-user-id="23"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.dropdown-avatar-initials[data-user-id="24"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.dropdown-avatar-initials[data-user-id="25"] { background: linear-gradient(135deg, #a855f7, #9333ea); }
.dropdown-avatar-initials[data-user-id="26"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.dropdown-avatar-initials[data-user-id="27"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.dropdown-avatar-initials[data-user-id="28"] { background: linear-gradient(135deg, #3b82f6, #2563eb); }
.dropdown-avatar-initials[data-user-id="29"] { background: linear-gradient(135deg, #10b981, #059669); }
.dropdown-avatar-initials[data-user-id="30"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }

/* Colores adicionales para más usuarios */
.member-initials-table[data-user-id="31"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.member-initials-table[data-user-id="32"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.member-initials-table[data-user-id="33"] { background: linear-gradient(135deg, #10b981, #059669); }
.member-initials-table[data-user-id="34"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.member-initials-table[data-user-id="35"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.member-initials-table[data-user-id="36"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.member-initials-table[data-user-id="37"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.member-initials-table[data-user-id="38"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.member-initials-table[data-user-id="39"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.member-initials-table[data-user-id="40"] { background: linear-gradient(135deg, #a855f7, #9333ea); }

/* Colores adicionales para dropdown */
.dropdown-avatar-initials[data-user-id="31"] { background: linear-gradient(135deg, #f59e0b, #d97706); }
.dropdown-avatar-initials[data-user-id="32"] { background: linear-gradient(135deg, #ef4444, #dc2626); }
.dropdown-avatar-initials[data-user-id="33"] { background: linear-gradient(135deg, #10b981, #059669); }
.dropdown-avatar-initials[data-user-id="34"] { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
.dropdown-avatar-initials[data-user-id="35"] { background: linear-gradient(135deg, #06b6d4, #0891b2); }
.dropdown-avatar-initials[data-user-id="36"] { background: linear-gradient(135deg, #84cc16, #65a30d); }
.dropdown-avatar-initials[data-user-id="37"] { background: linear-gradient(135deg, #f97316, #ea580c); }
.dropdown-avatar-initials[data-user-id="38"] { background: linear-gradient(135deg, #ec4899, #db2777); }
.dropdown-avatar-initials[data-user-id="39"] { background: linear-gradient(135deg, #14b8a6, #0d9488); }
.dropdown-avatar-initials[data-user-id="40"] { background: linear-gradient(135deg, #a855f7, #9333ea); }

/* Estilos para el spinner de carga */
.fa-spinner {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Responsive */
@media (max-width: 768px) {
    .table-header-minimal,
    .table-row-minimal {
        grid-template-columns: 1fr;
        gap: 8px;
    }
    
    .table-header-minimal {
        display: none; /* Ocultar header en móvil */
    }
    
    .table-row-minimal {
        padding: 16px;
        border-radius: 12px;
        margin-bottom: 12px;
        background: white;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.05);
    display: block;
}

    .cell-project, .cell-status, .cell-progress, .cell-tasks, .cell-actions {
    display: flex;
        justify-content: space-between;
    align-items: center;
        padding: 8px 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }
    
    .cell-project::before { content: "Miembro:"; }
    .cell-status::before { content: "Usuario:"; }
    .cell-progress::before { content: "Email:"; }
    .cell-tasks::before { content: "Estado:"; }
    .cell-actions::before { content: "Acciones:"; }
    
    .cell-project::before,
    .cell-status::before,
    .cell-progress::before,
    .cell-tasks::before,
    .cell-actions::before {
        font-weight: 600;
        color: var(--monday-text-secondary);
        font-size: 12px;
    text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .member-avatar-table {
        width: 28px;
        height: 28px;
    }
    
    .member-initials-table {
        width: 28px;
        height: 28px;
        font-size: 12px;
    }
    
    .dropdown-user-avatar {
        width: 36px;
        height: 36px;
    }
    
    .dropdown-avatar-initials {
        font-size: 14px;
    }
    
    .username-badge {
        font-size: 11px;
        padding: 3px 6px;
    }
    
    .email-text {
        font-size: 12px;
    }
    
    .status-badge {
        font-size: 11px;
        padding: 3px 8px;
    }
    
    .leader-badge-table {
        font-size: 11px;
        padding: 4px 8px;
    }
    
    /* Paginación responsive */
    .pagination-container-monday {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
    
    .pagination-controls-monday {
        width: 100%;
        justify-content: center;
    }
    
    .btn-pagination-monday, .btn-page-monday {
        padding: 6px 12px;
        min-width: 32px;
        height: 32px;
        font-size: 12px;
    }
    
    .pagination-info-monday {
        text-align: center;
        font-size: 12px;
    }
    
    /* Animación Lottie responsive */
    .lottie-animation-container dotlottie-wc {
        width: 200px !important;
        height: 200px !important;
    }
}
</style>

<?php
// Guardar el contenido en una variable
$content = ob_get_clean();

// CSS adicional para Clan Leader
$additionalCSS = [
    APP_URL . 'assets/css/clan-leader.css'
];

// JavaScript adicional para Clan Leader  
$additionalJS = [
    APP_URL . 'assets/js/clan-leader.js'
];

// Incluir el layout
require_once __DIR__ . '/../admin/layout.php';
?> 