<?php
/**
 * Bootstrap de la aplicación
 * Carga todas las dependencias y configuraciones necesarias y configuraciones
 */

// Incluir configuraciones
require_once __DIR__ . '/../config/app.php';

// Autoloader para las clases de la aplicación (PSR-4 Standard)
spl_autoload_register(function ($className) {
    $directories = [
        __DIR__ . '/models/',
        __DIR__ . '/controllers/'
    ];
    
    foreach ($directories as $directory) {
        $file = $directory . $className . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Configurar parámetros de sesión antes de iniciarla
if (session_status() === PHP_SESSION_NONE) {
    // Configuración de seguridad de sesión
    ini_set('session.cookie_httponly', 1);        // Prevenir acceso JavaScript a cookies de sesión
    ini_set('session.use_only_cookies', 1);       // Solo usar cookies para sesiones
    ini_set('session.cookie_secure', 0);          // 0 para HTTP, cambiar a 1 si usas HTTPS
    ini_set('session.cookie_samesite', 'Lax');    // Protección CSRF
    ini_set('session.use_strict_mode', 1);        // Rechazar IDs de sesión no inicializados
    ini_set('session.cookie_lifetime', 0);        // Cookie expira al cerrar navegador (sin "recordarme")
    ini_set('session.gc_maxlifetime', 7200);      // Sesión expira después de 2 horas de inactividad
    
    session_start();
    
    // Regenerar ID de sesión periódicamente para seguridad
    if (!isset($_SESSION['created'])) {
        $_SESSION['created'] = time();
    } else if (time() - $_SESSION['created'] > 1800) {
        // Regenerar ID cada 30 minutos
        session_regenerate_id(true);
        $_SESSION['created'] = time();
    }
    
    // Validar timeout de sesión (2 horas)
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 7200)) {
        // Sesión expirada por inactividad
        session_unset();
        session_destroy();
        session_start();
    }
    $_SESSION['last_activity'] = time();
}
